package net.wicp.tams.common.binlog.self.constant;

/***
 * The capability flags are used by the client and server to indicate which
 * features they support and want to use.
 * 
 * http://dev.mysql.com/doc/internals/en/capability-flags.html#packet-Protocol::
 * CapabilityFlags
 * 
 * @author zhoujunhui
 *
 */
public enum CapabilityFlags {
	CLIENT_LONG_PASSWORD("", 0x00000001),

	CLIENT_FOUND_ROWS("", 0x00000002),

	CLIENT_LONG_FLAG("", 0x00000004),

	CLIENT_CONNECT_WITH_DB("", 0x00000008),

	CLIENT_NO_SCHEMA("", 0x00000010),

	CLIENT_COMPRESS("", 0x00000020),

	CLIENT_ODBC("", 0x00000040),

	CLIENT_LOCAL_FILES("", 0x00000080),

	CLIENT_IGNORE_SPACE("", 0x00000100),

	CLIENT_PROTOCOL_41("", 0x00000200),

	CLIENT_INTERACTIVE("", 0x00000400),

	CLIENT_SSL("", 0x00000800),

	CLIENT_IGNORE_SIGPIPE("", 0x00001000),

	CLIENT_TRANSACTIONS("", 0x00002000),

	CLIENT_RESERVED("", 0x00004000),

	CLIENT_SECURE_CONNECTION("", 0x00008000),

	CLIENT_MULTI_STATEMENTS("", 0x00010000),

	CLIENT_MULTI_RESULTS("", 0x00020000),

	CLIENT_PS_MULTI_RESULTS("", 0x00040000),

	CLIENT_PLUGIN_AUTH("", 0x00080000),

	CLIENT_CONNECT_ATTRS("", 0x00100000),

	CLIENT_PLUGIN_AUTH_LENENC_CLIENT_DATA("", 0x00200000),

	CLIENT_CAN_HANDLE_EXPIRED_PASSWORDS("", 0x00400000),

	CLIENT_SESSION_TRACK("", 0x00800000),

	CLIENT_DEPRECATE_EOF("", 0x01000000);

	private final String desc;
	private final int value;// 值

	private CapabilityFlags(String desc, int value) {
		this.desc = desc;
		this.value = value;
	}

	public static CapabilityFlags get(int val) {
		for (CapabilityFlags capabilityFlags : CapabilityFlags.values()) {
			if (capabilityFlags.getValue() == val) {
				return capabilityFlags;
			}
		}
		return null;
	}

	/***
	 * 默认的Capability
	 * 
	 * @return
	 */
	public static int defaultCapability() {
		return CLIENT_LONG_FLAG.getValue() | CLIENT_PROTOCOL_41.getValue() | CLIENT_SECURE_CONNECTION.getValue();
	}

	public String getDesc() {
		return desc;
	}

	public int getValue() {
		return value;
	}
}
