package net.wicp.tams.common.binlog.self.constant;

public enum Capability {
	unknown(0, "MySQL or old MariaDB slave with no announced capability."),

	annotate(1, "MariaDB >= 5.3, which understands ANNOTATE_ROWS_EVENT."),

	tolerateHoles(2,
			" MariaDB >= 5.5. This version has the capability to tolerate events  omitted from the binlog stream without breaking replication (MySQL slaves fail because they mis-compute the offsets into the master's binlog)."),

	binlogCheckPoint(3, "MariaDB >= 10.0, which knows about binlog_checkpoint_log_event."),

	gtid(4, "MariaDB >= 10.0.1, which knows about global transaction id events.");

	private final String desc;
	private final int value;// 值

	public String getDesc() {
		return desc;
	}

	public int getValue() {
		return value;
	}

	private Capability(int value, String desc) {
		this.value = value;
		this.desc = desc;
	}
}
