package net.wicp.tams.common.binlog.self.callback.column;

import java.sql.Timestamp;

import com.alibaba.fastjson.annotation.JSONField;

import lombok.Builder;
import lombok.Data;
import net.wicp.tams.common.binlog.self.callback.ICol;
import net.wicp.tams.common.binlog.self.constant.ColumnType;
import net.wicp.tams.common.constant.DateFormatCase;

@Builder
@Data
public class ColTimestamp implements ICol<Timestamp> {
	private static final long serialVersionUID = 1L;

	private Timestamp value;
	private ColumnType colType;
	private String colName;

	@JSONField(serialize = false)
	@Override
	public String getClient() {
		return DateFormatCase.YYYY_MM_DD_hhmmss.getInstanc().format(value);
	}

	public ColTimestamp(Timestamp value, ColumnType colType, String colName) {
		super();
		this.value = value;
		this.colType = colType;
		this.colName = colName;
	}

}
