package net.wicp.tams.common.binlog.self.callback.column;

import java.sql.Time;

import com.alibaba.fastjson.annotation.JSONField;

import lombok.Builder;
import lombok.Data;
import net.wicp.tams.common.binlog.self.callback.ICol;
import net.wicp.tams.common.binlog.self.constant.ColumnType;
import net.wicp.tams.common.constant.DateFormatCase;

@Builder
@Data
public class ColTimeSql implements ICol<Time> {
	private static final long serialVersionUID = 1L;

	private Time value;
	private ColumnType colType;
	private String colName;

	@JSONField(serialize = false)
	@Override
	public String getClient() {
		return DateFormatCase.YYYY_MM_DD_hhmmss.getInstanc().format(value);
	}

	public ColTimeSql(Time value, ColumnType colType, String colName) {
		super();
		this.value = value;
		this.colType = colType;
		this.colName = colName;
	}

}
