package net.wicp.tams.common.binlog.self.callback.column;

import com.alibaba.fastjson.annotation.JSONField;

import lombok.Builder;
import lombok.Data;
import net.wicp.tams.common.binlog.self.callback.ICol;
import net.wicp.tams.common.binlog.self.constant.ColumnType;

@Builder
@Data
public class ColLong implements ICol<Long> {
	private static final long serialVersionUID = 1L;
	private Long value;
	private ColumnType colType;
	private String colName;

	@JSONField(serialize = false)
	@Override
	public String getClient() {
		return String.valueOf(value);
	}

	public ColLong(Long value, ColumnType colType, String colName) {
		super();
		this.value = value;
		this.colType = colType;
		this.colName = colName;
	}

}
