package net.wicp.tams.common.binlog.self.callback.column;

import com.alibaba.fastjson.annotation.JSONField;

import lombok.Builder;
import lombok.Data;
import net.wicp.tams.common.binlog.self.callback.ICol;
import net.wicp.tams.common.binlog.self.constant.ColumnType;

/***
 * 解析异常对象
 * 
 * @author zhoujunhui
 *
 */
@Builder
@Data
public class ColException implements ICol<String> {
	private static final long serialVersionUID = 1L;
	private String value;
	private ColumnType colType;
	private String colName;

	@JSONField(serialize = false)
	@Override
	public String getClient() {
		return "";
	}

	public ColException(String value, ColumnType colType, String colName) {
		super();
		this.value = value;
		this.colType = colType;
		this.colName = colName;
	}

}