package net.wicp.tams.common.binlog.self.callback.column;

import java.io.UnsupportedEncodingException;

import com.alibaba.fastjson.annotation.JSONField;

import lombok.Builder;
import lombok.Data;
import net.wicp.tams.common.binlog.self.callback.ICol;
import net.wicp.tams.common.binlog.self.constant.ColumnType;

@Builder
@Data
public class ColBytes implements ICol<byte[]> {
	private static final long serialVersionUID = 1L;

	private byte[] value;
	private ColumnType colType;
	private String colName;

	@JSONField(serialize = false)
	@Override
	public String getClient() {
		try {
			return new String(value, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			return null;
		}
	}

	public ColBytes(byte[] value, ColumnType colType, String colName) {
		super();
		this.value = value;
		this.colType = colType;
		this.colName = colName;
	}

}
