package net.wicp.tams.common.binlog.self.callback.column;

import java.math.BigDecimal;

import com.alibaba.fastjson.annotation.JSONField;

import lombok.Builder;
import lombok.Data;
import net.wicp.tams.common.binlog.self.callback.ICol;
import net.wicp.tams.common.binlog.self.constant.ColumnType;

@Builder
@Data
public class ColBigDecimal implements ICol<BigDecimal> {
	private static final long serialVersionUID = 1L;
	private BigDecimal value;
	private ColumnType colType;
	private String colName;

	@JSONField(serialize = false)
	@Override
	public String getClient() {
		return String.valueOf(value);
	}

	public ColBigDecimal(BigDecimal value, ColumnType colType, String colName) {
		super();
		this.value = value;
		this.colType = colType;
		this.colName = colName;
	}

	/*
	 * @Override public JSONObject getJson(String colName) { return new
	 * JSONObject(colName, obj); }
	 */

}
