package net.wicp.tams.common.binlog.self.bean;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import lombok.Builder;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.binlog.self.constant.ColumnType;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;

@Data
@Builder
@Slf4j
public class TableMapBean {
	// 所有的tablemap数据
	// public static Map<Long, TableMapBean> tbs = new HashMap<>();
	// 过滤的库名和表名
	// public static String dbPattern;
	// public static String tbPattern;

	private long tableId;
	private int flags;
	private String schemaName;
	private String tableName;
	private int columnCount;
	private ColumnType[] columnTypes;
	private int[] metaDefs;
	private byte[] nullBits;

	public List<String> getCols() {
		Host host = (Host) PerthreadManager.getInstance().createValue("zorro-host").get(new Host());
		List<String> cols = host.getCols(schemaName, tableName);
		if (CollectionUtils.isEmpty(cols)) {
			throw new IllegalAccessError("没有得到列名信息，请确认登陆用户是否有权限");
		}
		return cols;
	}
}
