package net.wicp.tams.common.binlog.self;

import java.io.IOException;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.binlog.self.bean.CountNum;
import net.wicp.tams.common.binlog.self.bean.Pos;

public interface IBinlogRead {
	public static final byte[] BINLOG_MAGIC = new byte[] { (byte) 0xfe, (byte) 0x62, (byte) 0x69, (byte) 0x6e };// 魔数

	public static final int HEAD_LENGTH = 19;

	public static final String BIN_ROW = "[%s:0x%s]";

	public Result checkHead();

	public void read(long pos) throws IOException;

	/***
	 * 返回当前的位点
	 * 
	 * @return
	 */
	public Pos curPos();

	/***
	 * 返回统计数据
	 * 
	 * @return
	 */
	public CountNum getCountNum();

	/***
	 * 重置增、删、改统计数据
	 */
	public void resetNum();

}
