/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.plugin.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcData;
import net.wicp.tams.common.apiext.jdbc.JdbcDatas;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.binlog.listener.AbsBinlogListener;
import net.wicp.tams.common.constant.JvmStatus;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.jdbc.DruidAssit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerJdbc
extends AbsBinlogListener {
    private static final Logger log = LoggerFactory.getLogger(ListenerJdbc.class);

    public void doInit(Rule rule, int index) {
        String dbinstanceid = (String)rule.getItems().get(RuleItem.dbinstanceid);
        Validate.isTrue((boolean)StringUtil.isNotNull((Object)dbinstanceid), (String)"\u6bcf\u7ec4\u89c4\u5219\u90fd\u9700\u8981\u914d\u7f6edbinstanceid\u3002", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtil.isNotNull(rule.getItems().get(RuleItem.dbtb)), (String)"\u6bcf\u7ec4\u89c4\u5219\u90fd\u9700\u8981\u914d\u7f6edbtb\u3002", (Object[])new Object[0]);
        Properties newprops = Conf.replacePre((String)String.format("common.binlog.alone.plugin.jdbc.%s.", dbinstanceid), (String)("common.jdbc.datasource." + dbinstanceid));
        Conf.overProp((Properties)newprops);
    }

    public Result doAlterTableCallBack(Rule rule, ListenerConf.ColHis colHis, String altersql, String[] addColNames, String updateColName, String[] deleteColNames) {
        Connection connection = DruidAssit.getConnection((String)((String)rule.getItems().get(RuleItem.dbinstanceid)));
        String[] dbtb = ((String)rule.getItems().get(RuleItem.dbtb)).split("\\.");
        String[][] cols = MySqlAssit.getCols((Connection)connection, (String)dbtb[0], (String)dbtb[1], (YesOrNo)YesOrNo.no);
        ArrayList<Pair> addColAndSqlType = new ArrayList<Pair>();
        for (int i = 0; i < colHis.getColsCount(); ++i) {
            if (ArrayUtils.contains((Object[])cols[0], (Object)colHis.getCols(i))) continue;
            addColAndSqlType.add(Pair.of((Object)colHis.getCols(i), (Object)colHis.getColTypes2(i)));
        }
        if (CollectionUtils.isEmpty(addColAndSqlType)) {
            return Result.getSuc();
        }
        StringBuffer sqlbuf = new StringBuffer(String.format("ALTER TABLE `%s`.`%s` ", dbtb[0], dbtb[1]));
        String sql = null;
        if (StringUtil.isNull((Object)altersql)) {
            for (Pair pair : addColAndSqlType) {
                sqlbuf.append(String.format("ADD COLUMN `%s` %s NULL,", pair.getLeft(), pair.getRight()));
            }
            sql = sqlbuf.substring(0, sqlbuf.length() - 1);
        } else {
            String toLowerSql = altersql.toLowerCase();
            int firstadd = toLowerSql.indexOf("add ");
            sqlbuf.append(toLowerSql.substring(firstadd));
            sql = sqlbuf.toString();
        }
        log.info("\u4fee\u6539\u8868\u7ed3\u6784\uff1a[{}]", (Object)sql);
        try {
            connection.createStatement().execute(sql);
            connection.close();
        }
        catch (SQLException e) {
            log.error("\u4f60\u6ca1\u6709\u6743\u9650\u4fee\u6539\u8868\u7ed3\u6784\uff0c\u8bf7\u624b\u52a8\u521b\u5efa:", (Throwable)e);
            LoggerUtil.exit((JvmStatus)JvmStatus.s15);
            return Result.getError((String)("\u4f60\u6ca1\u6709\u6743\u9650\u4fee\u6539\u8868\u7ed3\u6784\uff0c\u8bf7\u624b\u52a8\u521b\u5efa:" + e.getMessage()));
        }
        return Result.getSuc();
    }

    public void doBusiTrue(Rule rule, ListenerConf.DuckulaEvent duckulaEvent, boolean isSplit) {
        Connection connection = DruidAssit.getConnection((String)((String)rule.getItems().get(RuleItem.dbinstanceid)));
        JdbcDatas.Builder builder = JdbcDatas.newBuilder();
        String[] dbtb = ((String)rule.getItems().get(RuleItem.dbtb)).split("\\.");
        builder.setDb(dbtb[0]);
        builder.setTb(dbtb[1]);
        builder.addAllCols((Iterable)duckulaEvent.getColsList());
        builder.setOptTypeValue(duckulaEvent.getOptTypeValue());
        builder.addKeys(duckulaEvent.getCols(0));
        HashMap<String, String> typemap = new HashMap<String, String>();
        for (int i = 0; i < duckulaEvent.getColsCount(); ++i) {
            typemap.put(duckulaEvent.getCols(i), duckulaEvent.getColsType(i).name());
        }
        builder.putAllType(typemap);
        ArrayList<JdbcData> datas = new ArrayList<JdbcData>();
        for (int i = 0; i < duckulaEvent.getItemsCount(); ++i) {
            JdbcData.Builder dataBuilder = JdbcData.newBuilder();
            dataBuilder.putAllValue(DuckulaAssit.getValueMap((ListenerConf.DuckulaEvent)duckulaEvent, (int)i));
            datas.add(dataBuilder.build());
        }
        builder.addAllDatas(datas);
        Result dataUpset = MySqlAssit.dataChange((Connection)connection, (JdbcDatas)builder.build());
        if (!dataUpset.isSuc()) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.jdbc_exec_fail, "\u4fdd\u5b58\u6570\u636e\u5931\u8d25");
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

