/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.plugin.jdbc;

import com.alibaba.fastjson.JSONObject;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.jdbc.JdbcData;
import net.wicp.tams.common.apiext.jdbc.JdbcDatas;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.apiext.jdbc.OptType;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiSender;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.jdbc.DruidAssit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumperJdbc
implements IBusiSender<DumpEvent> {
    private static final Logger log = LoggerFactory.getLogger(DumperJdbc.class);
    private String dbinstanceid;
    private String db;
    private String tb;

    public void init(Dump dump) {
        Validate.notEmpty((Map)dump.getBusiPluginConfig(), (String)"\u9700\u8981\u6269\u5c55\u5c5e\u6027", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dump.getBusiPluginConfig().getString(RuleItem.dbinstanceid.name()), (String)"\u9700\u8981\u6269\u5c55\u5c5e\u6027\uff0c\u5b83\u662f\u4e00\u4e2ajson\u4e14\u5305\u542b\u6709 dbinstanceid\u503c\u3002", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dump.getBusiPluginConfig().getString(RuleItem.dbtb.name()), (String)"\u9700\u8981\u6269\u5c55\u5c5e\u6027\uff0c\u5b83\u662f\u4e00\u4e2ajson\u4e14\u5305\u542b\u6709 dbtb\u503c\u3002", (Object[])new Object[0]);
        this.dbinstanceid = dump.getBusiPluginConfig().getString(RuleItem.dbinstanceid.name());
        String[] dbtb = dump.getBusiPluginConfig().getString(RuleItem.dbtb.name()).split("\\.");
        this.db = dbtb[0];
        this.tb = dbtb[1];
        Properties newprops = Conf.replacePre((String)String.format("common.binlog.alone.plugin.jdbc.%s.", this.dbinstanceid), (String)("common.jdbc.datasource." + this.dbinstanceid));
        Conf.overProp((Properties)newprops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSend(DumpEvent dumpEvent) {
        JdbcDatas.Builder newBuilder = JdbcDatas.newBuilder();
        newBuilder.addAllCols(Arrays.asList(dumpEvent.getDump().getNeedCols()));
        newBuilder.setDb(this.db);
        newBuilder.setTb(this.tb);
        newBuilder.setOptType(OptType.update);
        newBuilder.addAllKeys(Arrays.asList(dumpEvent.getDump().getPrimarys()));
        for (int i = 0; i < dumpEvent.getDump().getNeedCols().length; ++i) {
            newBuilder.putType(dumpEvent.getDump().getNeedCols()[i], dumpEvent.getDump().getNeedColTypes()[i].name());
        }
        for (Map data : dumpEvent.getDatas()) {
            JdbcData.Builder jdbcDataBuild = JdbcData.newBuilder();
            jdbcDataBuild.putAllValue(data);
            newBuilder.addDatas(jdbcDataBuild);
        }
        Connection conn = DruidAssit.getConnection((String)this.dbinstanceid);
        try {
            Result temp = MySqlAssit.dataChange((Connection)conn, (JdbcDatas)newBuilder.build());
            if (!temp.isSuc()) {
                log.error("\u540c\u6b65\u9519\u8bef,\u539f\u56e0\uff1a{}", (Object)temp.getMessage());
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.jdbc_exec_fail);
            }
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                log.error("close the connection error", (Throwable)e);
            }
        }
    }

    public void initParams(JSONObject params) {
    }
}

