/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.dump.handlerConsumer;

import com.lmax.disruptor.WorkHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.apiext.TimeAssist;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiSender;
import net.wicp.tams.common.binlog.dump.DumpGroup;
import net.wicp.tams.common.binlog.dump.MainDump;
import net.wicp.tams.common.binlog.dump.handlerConsumer.Publisher;
import net.wicp.tams.common.constant.JvmStatus;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendHander
implements WorkHandler<DumpEvent> {
    private static final Logger log = LoggerFactory.getLogger(SendHander.class);
    private final Map<String, IBusiSender<DumpEvent>> sendmap = new HashMap<String, IBusiSender<DumpEvent>>();
    private final Map<String, Dump> dumpmap = new HashMap<String, Dump>();
    private final String formatestr = "%s.%s";
    private static CountDownLatch countDownLatch;

    public static void setCountDownLatch(CountDownLatch countDownLatch) {
        SendHander.countDownLatch = countDownLatch;
    }

    public SendHander(Dump[] dumps) {
        for (Dump dump : dumps) {
            this.sendmap.put(String.format("%s.%s", dump.getDbDemo(), dump.getTbDemo()), (IBusiSender<DumpEvent>)dump.getBusiSender());
            this.dumpmap.put(String.format("%s.%s", dump.getDbDemo(), dump.getTbDemo()), dump);
        }
    }

    public void onEvent(DumpEvent event) throws Exception {
        Thread.currentThread().setName("SendHanderThread");
        String key = String.format("%s.%s", event.getDump().getDbDemo(), event.getDump().getTbDemo());
        IBusiSender<DumpEvent> iBusiSend = this.sendmap.get(key);
        DumpGroup dumpGroup = MainDump.metricsMap.get(this.dumpmap.get(key).getId());
        if (iBusiSend == null || event == null || CollectionUtils.isEmpty((Collection)event.getDatas())) {
            dumpGroup.counter_send_num.inc((long)event.getDatas().size());
            dumpGroup.counter_send_event.inc();
            this.dumpmap.get(key).setLastId(event.getEndId());
            this.isOver();
            return;
        }
        while (true) {
            try {
                iBusiSend.doSend((Object)event);
                dumpGroup.counter_send_num.inc((long)event.getDatas().size());
                dumpGroup.counter_send_event.inc();
                this.dumpmap.get(key).setLastId(event.getEndId());
                this.isOver();
            }
            catch (Throwable e) {
                boolean reDoWait = TimeAssist.reDoWait((String)"tams-send", (int)7);
                if (reDoWait) {
                    dumpGroup.counter_send_error.inc();
                    log.error("\u91cd\u8bd57\u6b21\u90fd\u4e0d\u80fd\u62ff\u5230\u94fe\u63a5\uff0c\u9000\u51fa");
                    LoggerUtil.exit((JvmStatus)JvmStatus.s15);
                    continue;
                }
                log.error("\u4e0d\u80fd\u53d1\u9001\u6570\u636e\uff0c\u91cd\u8bd5", e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isOver() {
        if (MainDump.ringBuffer.getCursor() - MainDump.ringBuffer.getMinimumGatingSequence() > 0L) {
            return;
        }
        boolean isover = true;
        for (Publisher publisher : MainDump.publishers) {
            if (publisher.isIsover()) continue;
            isover = false;
            break;
        }
        if (isover) {
            log.info("========dump sucess!========");
            try {
                MainDump.shutdown();
                log.info("shutdown executor sucess");
            }
            catch (Throwable throwable) {
                Conf.overProp((String[])new String[]{"common.binlog.alone.dump.global.isOver", "true"});
                if (Conf.getBoolean((String)"common.binlog.alone.dump.global.overExit").booleanValue()) {
                    LoggerUtil.exit((JvmStatus)JvmStatus.s15);
                }
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
                throw throwable;
            }
            Conf.overProp((String[])new String[]{"common.binlog.alone.dump.global.isOver", "true"});
            if (Conf.getBoolean((String)"common.binlog.alone.dump.global.overExit").booleanValue()) {
                LoggerUtil.exit((JvmStatus)JvmStatus.s15);
            }
            if (countDownLatch != null) {
                countDownLatch.countDown();
            }
        }
    }
}

