/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.dump.handlerConsumer;

import com.lmax.disruptor.RingBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.TimeAssist;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.dump.MainDump;
import net.wicp.tams.common.constant.JvmStatus;
import net.wicp.tams.common.jdbc.DruidAssit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Publisher
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(Publisher.class);
    private final RingBuffer<DumpEvent> ringBuffer;
    private Connection connection;
    private PreparedStatement stmt;
    private int numDuan;
    private final int numBatch = Integer.parseInt(Conf.get((String)"common.binlog.alone.dump.global.batchNum"));
    private final long maxDuanNo;
    private final long maxBatchNo;
    private final String temp;
    private boolean isover = false;
    private final String startId;
    private final long numLastBatch;
    private final Dump dump;
    private int batchNo = 0;
    private int duanNo = 0;
    private long timeBegin = 0L;

    public Publisher(RingBuffer<DumpEvent> ringBuffer, Dump dump) {
        this.dump = dump;
        this.ringBuffer = ringBuffer;
        this.numDuan = dump.getNumDuan() == 0 ? 500 : dump.getNumDuan();
        Long recordNum = dump.getNumDump();
        if (recordNum != null && recordNum >= 0L) {
            this.maxBatchNo = recordNum / (long)this.numBatch + (long)(recordNum % (long)this.numBatch == 0L ? 0 : 1);
            long lastBatchRecords = recordNum - (this.maxBatchNo - 1L) * (long)this.numBatch;
            this.maxDuanNo = (this.maxBatchNo - 1L) * (long)(this.numBatch / this.numDuan + (this.numBatch % this.numDuan == 0 ? 0 : 1)) + lastBatchRecords / (long)this.numDuan + (long)(lastBatchRecords % (long)this.numDuan == 0L ? 0 : 1);
            this.numLastBatch = recordNum - (this.maxBatchNo - 1L) * (long)this.numBatch;
        } else {
            this.numLastBatch = this.numBatch;
            this.maxDuanNo = Long.MAX_VALUE;
            this.maxBatchNo = Long.MAX_VALUE;
        }
        this.startId = dump.getStartId();
        String primaryName = dump.getPrimarys()[0];
        this.temp = String.format("select %s %s and %s>=?  order by %s limit ?,?", primaryName, dump.packFromstr(), primaryName, primaryName);
        log.info("--------maxDuanNo={},maxBatchNo={}-------", (Object)(this.maxDuanNo == Long.MAX_VALUE ? -1L : this.maxDuanNo), (Object)(this.maxBatchNo == Long.MAX_VALUE ? -1L : this.maxBatchNo));
    }

    @Override
    public void run() {
        Thread.currentThread().setName("PublisherThread");
        String lastId = StringUtil.hasNull((String[])new String[]{this.startId, ""});
        boolean isFirstBatch = true;
        boolean isLastBatch = false;
        this.timeBegin = System.currentTimeMillis();
        while (true) {
            try {
                ResultSet rsDuan = null;
                while (true) {
                    try {
                        do {
                            if (this.connection == null || this.connection.isClosed()) {
                                if (this.stmt != null && this.stmt.isClosed()) {
                                    this.stmt.close();
                                }
                                this.connection = DruidAssit.getConnection((String)"_global");
                                this.stmt = this.connection.prepareStatement(this.temp);
                                this.stmt.setFetchSize(this.numBatch);
                            }
                            JdbcAssit.setPreParam((PreparedStatement)this.stmt, (Object[])new Object[]{lastId, isFirstBatch ? 0 : 1, isLastBatch && this.numLastBatch > 0L ? this.numLastBatch : (long)this.numBatch});
                        } while ((rsDuan = this.stmt.executeQuery()) == null);
                    }
                    catch (Throwable e) {
                        boolean reDoWait = TimeAssist.reDoWait((String)"tams-dump", (int)7);
                        if (reDoWait) {
                            log.error("\u91cd\u8bd57\u6b21\u90fd\u4e0d\u80fd\u62ff\u5230\u94fe\u63a5\uff0c\u9000\u51fa");
                            LoggerUtil.exit((JvmStatus)JvmStatus.s15);
                            continue;
                        }
                        log.error("\u4e0d\u80fd\u67e5\u8be2\u6570\u636e\uff0c\u91cd\u8bd5", e);
                        continue;
                    }
                    break;
                }
                int i = 0;
                String start = null;
                String end = null;
                if (!rsDuan.next()) break;
                start = rsDuan.getString(1);
                end = rsDuan.getString(1);
                ++i;
                while (rsDuan.next() && (long)this.duanNo < this.maxDuanNo) {
                    if (i == 0) {
                        start = rsDuan.getString(1);
                        end = rsDuan.getString(1);
                        ++i;
                        continue;
                    }
                    if (i == this.numDuan - 1) {
                        end = rsDuan.getString(1);
                        this.pushData(start, end);
                        lastId = end;
                        ++this.duanNo;
                        i = 0;
                        start = null;
                        end = null;
                        continue;
                    }
                    end = rsDuan.getString(1);
                    ++i;
                }
                if (start != null && end != null && (long)this.duanNo < this.maxDuanNo) {
                    this.pushData(start, end);
                    ++this.duanNo;
                    lastId = end;
                }
                ++this.batchNo;
                rsDuan.close();
            }
            catch (Exception e) {
                log.error("\u751f\u4ea7\u8005\u6267\u884c\u5931\u8d25", (Throwable)e);
                LoggerUtil.exit((JvmStatus)JvmStatus.s15);
            }
            if ((long)this.duanNo >= this.maxDuanNo) break;
            isLastBatch = (long)this.batchNo == this.maxBatchNo - 1L;
            isFirstBatch = false;
        }
        this.isover = true;
        try {
            this.stmt.close();
            this.connection.close();
        }
        catch (Exception e) {
            log.error("\u56de\u6536\u8d44\u6e90\u5931\u8d25", (Throwable)e);
        }
    }

    private void pushData(String start, String end) {
        long sequence = this.ringBuffer.next();
        DumpEvent event = (DumpEvent)this.ringBuffer.get(sequence);
        event.setBeginId(start);
        event.setEndId(end);
        event.setDump(this.dump);
        this.ringBuffer.publish(sequence);
    }

    public int getBatchNo() {
        return this.batchNo;
    }

    public int getDuanNo() {
        return this.duanNo;
    }

    public boolean isIsover() {
        return this.isover && MainDump.metricsMap.get((Object)this.dump.getId()).counter_send_event.getCount() == (long)this.getDuanNo();
    }

    public long getTimeBegin() {
        return this.timeBegin;
    }

    public Dump getDump() {
        return this.dump;
    }
}

