/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.dump.handlerConsumer;

import com.lmax.disruptor.WorkHandler;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleFilter;
import net.wicp.tams.common.binlog.alone.constant.FilterPattern;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiFilter;
import net.wicp.tams.common.constant.JvmStatus;
import net.wicp.tams.common.jdbc.DruidAssit;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusiHander
implements WorkHandler<DumpEvent> {
    private static final Logger log = LoggerFactory.getLogger(BusiHander.class);
    private final Map<String, IBusiFilter<DumpEvent>> filtermap = new HashMap<String, IBusiFilter<DumpEvent>>();
    private final String formatestr = "%s.%s";

    public BusiHander(Dump[] dumps) {
        for (Dump dump : dumps) {
            this.filtermap.put(String.format("%s.%s", dump.getDbDemo(), dump.getTbDemo()), (IBusiFilter<DumpEvent>)dump.getBusiFilter());
        }
    }

    public void onEvent(DumpEvent event) throws Exception {
        Thread.currentThread().setName("BusiHanderThread");
        for (RuleFilter filterRulePo : event.getDump().getRule().getFilterRules()) {
            if (filterRulePo.getFilterPattern() == FilterPattern.sql) {
                DataSource dataSource = DruidAssit.getDataSource((String)"_global");
                PerthreadManager.getInstance().createValue((Object)"_curthread", DataSource.class).set((Object)dataSource);
            }
            filterRulePo.getFilterPattern().getFilter().doFilter(event, event.getDump().getRule(), filterRulePo);
            if (event.getDatas().size() != 0) continue;
            log.info("---------------------\u8fc7\u6ee4\u540e\u6ca1\u6709\u5904\u7406\u7684\u6570\u636e-----------------------------");
            break;
        }
        if (event.getDatas().size() == 0) {
            return;
        }
        IBusiFilter<DumpEvent> iBusiFilter = this.filtermap.get(String.format("%s.%s", event.getDump().getDbDemo(), event.getDump().getTbDemo()));
        if (iBusiFilter == null) {
            return;
        }
        try {
            iBusiFilter.doBusi((Object)event);
        }
        catch (Throwable e) {
            log.error("\u4e1a\u52a1\u5904\u7406\u5931\u8d25", e);
            LoggerUtil.exit((JvmStatus)JvmStatus.s15);
        }
    }
}

