/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.dump.handlerConsumer;

import com.lmax.disruptor.WorkHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.jdbc.DruidAssit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseDataHander
implements WorkHandler<DumpEvent> {
    private static final Logger log = LoggerFactory.getLogger(BaseDataHander.class);
    private Connection connection;
    private final Map<String, PreparedStatement> stmtmap = new HashMap<String, PreparedStatement>();
    private final Map<String, String> sqlmap = new HashMap<String, String>();
    private final Map<String, Integer> duanmap = new HashMap<String, Integer>();
    private final String formatestr = "%s.%s";

    public BaseDataHander(Dump[] dumps) throws SQLException {
        this.connection = DruidAssit.getConnection((String)"_global");
        for (Dump dump : dumps) {
            String arrayJoin = CollectionUtil.arrayJoin((Object[])dump.getNeedCols(), (String)"`,`");
            String sql = String.format("select `%s` %s and %s >=? and %s<=?", arrayJoin, dump.packFromstr(), dump.getPrimarys()[0], dump.getPrimarys()[0]);
            String key = String.format("%s.%s", dump.getDbDemo(), dump.getTbDemo());
            this.sqlmap.put(key, sql);
            this.duanmap.put(key, dump.getNumDuan());
            PreparedStatement statement = this.connection.prepareStatement(sql);
            statement.setFetchSize(dump.getNumDuan());
            this.stmtmap.put(key, statement);
        }
    }

    public void onEvent(DumpEvent event) throws Exception {
        Thread.currentThread().setName("BaseDataHanderThread");
        this.initConn();
        PreparedStatement stmt = this.stmtmap.get(String.format("%s.%s", event.getDump().getDbDemo(), event.getDump().getTbDemo()));
        JdbcAssit.setPreParam((PreparedStatement)this.stmtmap.get(String.format("%s.%s", event.getDump().getDbDemo(), event.getDump().getTbDemo())), (Object[])new Object[]{event.getBeginId(), event.getEndId()});
        ResultSet rs = stmt.executeQuery();
        ArrayList datas = new ArrayList();
        while (rs.next()) {
            HashMap<String, String> datamap = new HashMap<String, String>();
            for (String colName : event.getDump().getNeedCols()) {
                String valuestr = rs.getString(colName);
                if (valuestr == null) continue;
                datamap.put(colName, valuestr);
            }
            datas.add(datamap);
        }
        event.setDatas(datas);
        try {
            rs.close();
        }
        catch (Exception e) {
            log.error("\u5173\u95edrs\u5931\u8d25", (Throwable)e);
        }
    }

    private void initConn() {
        while (true) {
            try {
                if (this.connection != null && !this.connection.isClosed()) break;
                this.connection = DruidAssit.getConnection((String)"_global");
                for (String key : this.stmtmap.keySet()) {
                    if (this.stmtmap.get(key) != null && this.stmtmap.get(key).isClosed()) {
                        this.stmtmap.get(key).close();
                    }
                    PreparedStatement statement = this.connection.prepareStatement(this.sqlmap.get(key));
                    statement.setFetchSize(this.duanmap.get(key));
                    this.stmtmap.put(key, statement);
                }
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u4e0a", (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
                continue;
            }
            break;
        }
    }
}

