/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.dump;

import com.alibaba.fastjson.JSONObject;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.IgnoreExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.WorkProcessor;
import com.lmax.disruptor.util.DaemonThreadFactory;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.binlog.Tools;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleManager;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiFilter;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiSender;
import net.wicp.tams.common.binlog.dump.BusiSenderEnum;
import net.wicp.tams.common.binlog.dump.DumpGroup;
import net.wicp.tams.common.binlog.dump.handlerConsumer.BaseDataHander;
import net.wicp.tams.common.binlog.dump.handlerConsumer.BusiHander;
import net.wicp.tams.common.binlog.dump.handlerConsumer.Publisher;
import net.wicp.tams.common.binlog.dump.handlerConsumer.SendHander;
import net.wicp.tams.common.binlog.dump.jmx.DumpControl;
import net.wicp.tams.common.constant.DateFormatCase;
import net.wicp.tams.common.constant.JvmStatus;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.jdbc.DruidAssit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainDump {
    private static final Logger log = LoggerFactory.getLogger(MainDump.class);
    private static final int BUFFER_SIZE = 8;
    public static final String chkDatasourceName = "_chk";
    private static final EventFactory<DumpEvent> EVENT_FACTORY = new EventFactory<DumpEvent>(){

        public DumpEvent newInstance() {
            return new DumpEvent();
        }
    };
    public static final RingBuffer<DumpEvent> ringBuffer = RingBuffer.createMultiProducer(EVENT_FACTORY, (int)8, (WaitStrategy)new BlockingWaitStrategy());
    Dump[] dumps = null;
    RuleManager ruleManager = null;
    private boolean needConf = false;
    public static Map<String, DumpGroup> metricsMap = new HashMap<String, DumpGroup>();
    SequenceBarrier baseBarrier;
    SequenceBarrier busiBarrier;
    public static Publisher[] publishers;
    private SendHander[] sendHanders;
    private static ExecutorService executor;
    private static ScheduledExecutorService timerService;
    Connection connectionChk = null;
    PreparedStatement stmt = null;
    private static long beginTime;

    public void dump() throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.dump(null);
    }

    public void dump(JSONObject params) throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (!Conf.getBoolean((String)"common.binlog.alone.dump.global.enable").booleanValue()) {
            return;
        }
        ClassLoader classloadertrue = Conf.pluginClassLoader((String)"common.binlog.alone.dump.global.busiPluginDir");
        Thread.currentThread().setName("Dump-main");
        Map dumpConfs = Conf.getPreGroup((String)"common.binlog.alone.dump.ori", (String[])new String[0]);
        if (MapUtils.isEmpty((Map)dumpConfs)) {
            System.err.println("----\u672a\u914d\u7f6edump\u4efb\u52a1\uff0c\u4e0d\u80fd\u542f\u52a8task----");
            log.error("----\u672a\u914d\u7f6edump\u4efb\u52a1\uff0c\u4e0d\u80fd\u542f\u52a8task----");
            return;
        }
        ArrayList<Dump> doList = new ArrayList<Dump>();
        Properties newprops = Conf.replacePre((String)"common.binlog.alone.dump.global.pool", (String)"common.jdbc.datasource._global");
        Conf.overProp((Properties)newprops);
        Connection connection = DruidAssit.getConnection((String)"_global");
        int i = 0;
        Map defaultOriConf = Conf.getPre((String)"common.binlog.alone.dump.global.ori", (boolean)true);
        for (String dumpIdTemp : dumpConfs.keySet()) {
            HashMap mergMap = new HashMap();
            mergMap.putAll(defaultOriConf);
            mergMap.putAll((Map)dumpConfs.get(dumpIdTemp));
            dumpConfs.put(dumpIdTemp, mergMap);
            String ruleStr = (String)mergMap.get("rule");
            if (StringUtil.isNull((Object)ruleStr)) {
                log.error("\u6b64dump\u6ca1\u6709\u89c4\u5219rule\u914d\u7f6e\uff1a{}", (Object)dumpIdTemp);
                continue;
            }
            this.ruleManager = new RuleManager(ruleStr);
            for (int j = 0; j < this.ruleManager.getRules().size(); ++j) {
                Rule rule = (Rule)this.ruleManager.getRules().get(j);
                String dumpId = String.format("%s-%s", dumpIdTemp, j);
                String dbPattern = rule.getDbPattern();
                String tbPattern = rule.getTbPattern();
                if (StringUtil.isNull((Object)dbPattern) || StringUtil.isNull((Object)tbPattern)) {
                    log.error("the dumpId:{} need db and tb.", (Object)dumpId);
                    continue;
                }
                Dump.DumpBuilder dumpBuilder = Dump.builder().id(dumpId);
                dumpBuilder.rule(rule);
                dumpBuilder.dbPattern(dbPattern).dbOri(rule.getDbOri()).dbDemo(rule.getDbOri());
                dumpBuilder.tbPattern(tbPattern).tbOri(rule.getTbOri()).tbDemo(rule.getTbOri());
                dumpBuilder.numDuan(Integer.parseInt((String)mergMap.get("numDuan")));
                Object[] primarys = MySqlAssit.getPrimary((Connection)connection, (String)rule.getDbOri(), (String)rule.getTbOri());
                dumpBuilder.primarys((String[])primarys);
                if (rule.getItems().containsKey(RuleItem.primarysLogic)) {
                    dumpBuilder.primarysLogic(((String)rule.getItems().get(RuleItem.primarysLogic)).split(","));
                }
                if (rule.getItems().containsKey(RuleItem.wheresql)) {
                    String wheresql = StringUtil.hasNull((String[])new String[]{(String)rule.getItems().get(RuleItem.wheresql)});
                    wheresql = wheresql.replace("|", "'");
                    dumpBuilder.wheresql(wheresql);
                }
                dumpBuilder.startId(StringUtil.hasNull((String[])new String[]{(String)rule.getItems().get(RuleItem.startId)}));
                dumpBuilder.numDump(!rule.containsItem(RuleItem.numDump) ? null : Long.valueOf(Long.parseLong((String)rule.getItems().get(RuleItem.numDump))));
                dumpBuilder.busiPluginConfig(rule.buildRuleItem());
                String[][] cols = MySqlAssit.getCols((Connection)connection, (String)rule.getDbOri(), (String)rule.getTbOri(), (YesOrNo)YesOrNo.yes);
                if (StringUtil.isNull(rule.getItems().get(RuleItem.needCols))) {
                    dumpBuilder.needCols(cols[0]);
                    dumpBuilder.needColTypes(Dump.convertColumnType((String[])cols[1]));
                } else {
                    Object[] configCols = ((String)rule.getItems().get(RuleItem.needCols)).split(",");
                    Object[] retEles = (String[])CollectionUtil.arrayAnd(String[].class, (Object[])cols[0], (Object[])configCols);
                    retEles = (String[])CollectionUtil.arrayMerge(String[].class, (Object[])retEles, (Object[])primarys);
                    String[] retTypes = new String[retEles.length];
                    for (int k = 0; k < retEles.length; ++k) {
                        int index = ArrayUtils.indexOf((Object[])cols[0], (Object)retEles[k]);
                        retTypes[k] = cols[1][index];
                    }
                    dumpBuilder.needCols((String[])retEles);
                    dumpBuilder.needColTypes(Dump.convertColumnType((String[])retTypes));
                }
                if (StringUtil.isNotNull(mergMap.get("busiFilter"))) {
                    IBusiFilter newInstance = (IBusiFilter)Class.forName((String)mergMap.get("busiFilter")).newInstance();
                    dumpBuilder.busiFilter(newInstance);
                }
                metricsMap.put(dumpId, new DumpGroup(dumpId));
                if (StringUtil.isNotNull(mergMap.get("busiSender"))) {
                    String busiSender = StringUtil.trimSpace((String)((String)mergMap.get("busiSender")));
                    try {
                        BusiSenderEnum busiSenderEnum = BusiSenderEnum.valueOf(busiSender);
                        if (busiSenderEnum != null) {
                            busiSender = busiSenderEnum.getClassName();
                        }
                    }
                    catch (Exception busiSenderEnum) {
                        // empty catch block
                    }
                    IBusiSender newInstance = (IBusiSender)classloadertrue.loadClass(busiSender).newInstance();
                    dumpBuilder.busiSender(newInstance);
                    Dump dump = dumpBuilder.build();
                    newInstance.init(dump);
                    newInstance.initParams(params);
                    doList.add(dump);
                } else {
                    doList.add(dumpBuilder.build());
                }
                log.info("========the dumpId index:{}, id:{} ======", (Object)i++, (Object)dumpId);
            }
        }
        if (CollectionUtils.isEmpty(doList)) {
            log.error("\u6ca1\u6709\u5408\u9002\u7684dump\u3002 \u9700\u8981\u68c0\u67e5\u914d\u7f6e.");
            LoggerUtil.exit((JvmStatus)JvmStatus.s15);
            return;
        }
        this.dumps = doList.toArray(new Dump[doList.size()]);
        log.info("----------------------\u521b\u5efalast\u7684\u4fdd\u5b58\u8868-------------------------------------");
        if (StringUtil.isNotNull((Object)Conf.get((String)"common.binlog.alone.binlog.global.chk.mysql.host"))) {
            Properties configprops = Conf.replacePre((String)"common.binlog.alone.binlog.global.chk.mysql", (String)"common.jdbc.datasource._chk");
            Conf.overProp((Properties)configprops);
            Connection connectionChk = DruidAssit.getConnection((String)chkDatasourceName);
            Statement stmt = connectionChk.createStatement();
            int executeUpdate = stmt.executeUpdate("CREATE TABLE IF NOT EXISTS `dump_lastid`  (`id` int(11) NOT NULL AUTO_INCREMENT,`dump_id` varchar(255)  NOT NULL,`db` varchar(255)  NOT NULL,`tb` varchar(255)  NOT NULL,`time` datetime(0) NOT NULL,`lastId` varchar(254)  NOT NULL,`speed` double NOT NULL, PRIMARY KEY (`id`))");
            stmt.close();
            connectionChk.close();
            if (executeUpdate != 0) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.jdbc_exec_fail, "\u521b\u5efatable\u5931\u8d25");
            }
            this.needConf = true;
        }
        log.info("----------------------\u542f\u52a8jmx-------------------------------------");
        try {
            MainDump.initMbean();
        }
        catch (Exception e) {
            log.error("\u542f\u52a8jmx\u9519\u8bef", (Throwable)e);
            LoggerUtil.exit((JvmStatus)JvmStatus.s15);
        }
        log.info("----------------------\u914d\u7f6emetrix-------------------------------------");
        log.info("----------------------\u542f\u52a8Disruptor-------------------------------------");
        try {
            this.disruptorRun();
        }
        catch (Exception e) {
            log.error("dump\u5931\u8d25,\u5c06\u5173\u673a\uff0c\u539f\u56e0\uff1a", (Throwable)e);
            LoggerUtil.exit((JvmStatus)JvmStatus.s15);
        }
        this.addTimer();
        Tools.printAscill();
    }

    private void disruptorRun() throws SQLException {
        int i;
        publishers = new Publisher[this.dumps.length];
        for (int i2 = 0; i2 < publishers.length; ++i2) {
            MainDump.publishers[i2] = new Publisher(ringBuffer, this.dumps[i2]);
        }
        Sequence workSequence = new Sequence(-1L);
        SequenceBarrier sequenceBarrier = ringBuffer.newBarrier(new Sequence[0]);
        int baseDataNum = Conf.getInt((String)"common.binlog.alone.dump.thread.baseDataNum");
        BaseDataHander[] baseDataHanders = new BaseDataHander[baseDataNum];
        for (int i3 = 0; i3 < baseDataHanders.length; ++i3) {
            baseDataHanders[i3] = new BaseDataHander(this.dumps);
        }
        WorkProcessor[] baseProcessors = new WorkProcessor[baseDataNum];
        for (int i4 = 0; i4 < baseProcessors.length; ++i4) {
            baseProcessors[i4] = new WorkProcessor(ringBuffer, sequenceBarrier, (WorkHandler)baseDataHanders[i4], (ExceptionHandler)new IgnoreExceptionHandler(), workSequence);
        }
        this.baseBarrier = ringBuffer.newBarrier(this.getSeqAry(baseProcessors));
        Sequence busiSequence = new Sequence(-1L);
        int busiNum = Conf.getInt((String)"common.binlog.alone.dump.thread.busiNum");
        BusiHander[] busiHanders = new BusiHander[busiNum];
        for (int i5 = 0; i5 < busiHanders.length; ++i5) {
            busiHanders[i5] = new BusiHander(this.dumps);
        }
        WorkProcessor[] busiProcessors = new WorkProcessor[busiNum];
        for (int i6 = 0; i6 < busiProcessors.length; ++i6) {
            busiProcessors[i6] = new WorkProcessor(ringBuffer, this.baseBarrier, (WorkHandler)busiHanders[i6], (ExceptionHandler)new IgnoreExceptionHandler(), busiSequence);
        }
        this.busiBarrier = ringBuffer.newBarrier(this.getSeqAry(busiProcessors));
        Sequence sendSequence = new Sequence(-1L);
        int sendNum = Conf.getInt((String)"common.binlog.alone.dump.thread.sendNum");
        this.sendHanders = new SendHander[sendNum];
        executor = Executors.newFixedThreadPool(publishers.length + baseDataNum + busiNum + sendNum, (ThreadFactory)DaemonThreadFactory.INSTANCE);
        for (int i7 = 0; i7 < this.sendHanders.length; ++i7) {
            this.sendHanders[i7] = new SendHander(this.dumps);
        }
        WorkProcessor[] sendProcessors = new WorkProcessor[sendNum];
        for (i = 0; i < sendProcessors.length; ++i) {
            sendProcessors[i] = new WorkProcessor(ringBuffer, this.busiBarrier, (WorkHandler)this.sendHanders[i], (ExceptionHandler)new IgnoreExceptionHandler(), sendSequence);
        }
        ringBuffer.addGatingSequences(this.getSeqAry(sendProcessors));
        for (i = 0; i < publishers.length; ++i) {
            executor.submit(publishers[i]);
        }
        for (WorkProcessor baseProcessor : baseProcessors) {
            executor.submit((Runnable)baseProcessor);
        }
        for (WorkProcessor busiProcessor : busiProcessors) {
            executor.submit((Runnable)busiProcessor);
        }
        for (WorkProcessor sendProcessor : sendProcessors) {
            executor.submit((Runnable)sendProcessor);
        }
        this.addShutdownHook();
        beginTime = System.currentTimeMillis();
    }

    private Sequence[] getSeqAry(WorkProcessor<DumpEvent>[] baseProcessors) {
        Sequence[] seqAry = new Sequence[baseProcessors.length];
        for (int i = 0; i < seqAry.length; ++i) {
            seqAry[i] = baseProcessors[i].getSequence();
        }
        return seqAry;
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.info("----------------------\u6267\u884c\u5173\u95ed\u8fdb\u7a0b \u94a9\u5b50\u5f00\u59cb-------------------------------------");
                MainDump.this.updateLastId();
                log.info("----------------------\u6267\u884c\u5173\u95ed\u8fdb\u7a0b \u94a9\u5b50\u5b8c\u6210-------------------------------------");
            }
        });
    }

    private static void initMbean() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException {
        DumpControl control = new DumpControl();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        mbs.registerMBean(control, new ObjectName("Commons:name=dumpBean"));
        log.info("----------------------MBean\u6ce8\u518c\u6210\u529f-------------------------------------");
    }

    private void addTimer() {
        timerService = Executors.newSingleThreadScheduledExecutor();
        timerService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                MainDump.this.updateLastId();
                MainDump.this.isOver();
            }
        }, 10L, 3L, TimeUnit.SECONDS);
    }

    public static void shutdown() {
        try {
            executor.shutdown();
        }
        catch (Throwable e) {
            log.error("\u5173\u95ed\u7ebf\u7a0b\u6c60\u5931\u8d25");
        }
        try {
            timerService.shutdown();
        }
        catch (Throwable e) {
            log.error("\u5173\u95ed\u5b9a\u65f6\u5668\u5931\u8d25");
        }
    }

    private void updateLastId() {
        long min = ringBuffer.getMinimumGatingSequence();
        if (ArrayUtils.isEmpty((Object[])this.dumps)) {
            return;
        }
        long timeUse = System.currentTimeMillis() - beginTime;
        for (Dump dump : this.dumps) {
            double speed = MainDump.metricsMap.get((Object)dump.getId()).counter_send_num.getCount() * 1000L / timeUse;
            if (this.needConf) {
                try {
                    if (this.connectionChk == null || this.connectionChk.isClosed()) {
                        this.connectionChk = DruidAssit.getConnection((String)chkDatasourceName);
                        this.stmt = this.connectionChk.prepareStatement("INSERT INTO `dump_lastid`(`dump_id` ,`db`,`tb`,`time`,`lastId` ,`speed` ) VALUES (?, ?, ?, ?, ?, ?)");
                    }
                    String curTimeStr = DateFormatCase.YYYY_MM_DD_hhmmss.getInstanc().format(System.currentTimeMillis());
                    JdbcAssit.setPreParam((PreparedStatement)this.stmt, (Object[])new Object[]{dump.getId(), dump.getDbOri(), dump.getTbOri(), curTimeStr, dump.getLastId(), speed});
                    this.stmt.execute();
                }
                catch (Exception e) {
                    log.error("save last error", (Throwable)e);
                }
                continue;
            }
            log.info("-------------------------table:{}.{}, speed:{},lastId:{}", new Object[]{dump.getDbOri(), dump.getTbOri(), speed, dump.getLastId()});
        }
        log.info("-------------------------time:{} minute,undo size:{},sendDuanNo:{},busiDuanNo:{},baseDateDuanNo:{},publisher:{}", new Object[]{timeUse / 60000L, ringBuffer.getCursor() - min, min, this.busiBarrier.getCursor(), this.baseBarrier.getCursor(), ringBuffer.getCursor()});
    }

    private void isOver() {
        this.sendHanders[0].isOver();
    }
}

