/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone.proxy;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.IgnoreExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.WorkProcessor;
import com.lmax.disruptor.util.DaemonThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.binlog.alone.beans.RingBuffMonitor;
import net.wicp.tams.common.binlog.alone.binlog.bean.PushlishBean;
import net.wicp.tams.common.binlog.alone.constant.BuffType;
import net.wicp.tams.common.binlog.alone.handlerConsumer.disruptor.BusiHander;
import net.wicp.tams.common.binlog.alone.handlerConsumer.disruptor.SendHander;
import net.wicp.tams.common.constant.JvmStatus;
import org.apache.commons.beanutils.BeanUtils;

public class Disruptor
extends BuffType.BinlogListenerProxy {
    private final int BUFFER_SIZE = 256;
    private final EventFactory<PushlishBean> EVENT_FACTORY = new EventFactory<PushlishBean>(){

        public PushlishBean newInstance() {
            return new PushlishBean();
        }
    };
    private final RingBuffer<PushlishBean> ringBuffer = RingBuffer.createSingleProducer(this.EVENT_FACTORY, (int)256, (WaitStrategy)new BlockingWaitStrategy());

    public Disruptor() {
        Sequence workSequence = new Sequence(-1L);
        SequenceBarrier sequenceBarrier = this.ringBuffer.newBarrier(new Sequence[0]);
        int busiNum = Conf.getInt((String)"common.binlog.alone.binlog.global.disruptor.busiNum");
        BusiHander[] busiHanders = new BusiHander[busiNum];
        for (int i = 0; i < busiHanders.length; ++i) {
            busiHanders[i] = new BusiHander();
        }
        WorkProcessor[] busiProcessors = new WorkProcessor[busiNum];
        for (int i = 0; i < busiProcessors.length; ++i) {
            busiProcessors[i] = new WorkProcessor(this.ringBuffer, sequenceBarrier, (WorkHandler)busiHanders[i], (ExceptionHandler)new IgnoreExceptionHandler(), workSequence);
        }
        SequenceBarrier busiBarrier = this.ringBuffer.newBarrier(this.getSeqAry(busiProcessors));
        Sequence sendSequence = new Sequence(-1L);
        int sendNum = Conf.getInt((String)"common.binlog.alone.binlog.global.disruptor.sendNum");
        SendHander[] sendHanders = new SendHander[sendNum];
        for (int i = 0; i < sendHanders.length; ++i) {
            sendHanders[i] = new SendHander();
        }
        WorkProcessor[] sendProcessors = new WorkProcessor[sendNum];
        for (int i = 0; i < sendProcessors.length; ++i) {
            sendProcessors[i] = new WorkProcessor(this.ringBuffer, busiBarrier, (WorkHandler)sendHanders[i], (ExceptionHandler)new IgnoreExceptionHandler(), sendSequence);
        }
        this.ringBuffer.addGatingSequences(this.getSeqAry(sendProcessors));
        ExecutorService executor = Executors.newFixedThreadPool(busiNum + sendNum, (ThreadFactory)DaemonThreadFactory.INSTANCE);
        for (WorkProcessor busiProcessor : busiProcessors) {
            executor.submit((Runnable)busiProcessor);
        }
        for (WorkProcessor sendProcessor : sendProcessors) {
            executor.submit((Runnable)sendProcessor);
        }
    }

    @Override
    public void close() {
    }

    private Sequence[] getSeqAry(WorkProcessor<PushlishBean>[] baseProcessors) {
        Sequence[] seqAry = new Sequence[baseProcessors.length];
        for (int i = 0; i < seqAry.length; ++i) {
            seqAry[i] = baseProcessors[i].getSequence();
        }
        return seqAry;
    }

    @Override
    public RingBuffMonitor getCurDoWithSize() {
        long min = this.ringBuffer.getMinimumGatingSequence();
        long cursor = this.ringBuffer.getCursor();
        RingBuffMonitor retobj = new RingBuffMonitor();
        retobj.getUndoSize().getAndSet(cursor - min);
        retobj.getSenderUnit().getAndSet(min);
        return retobj;
    }

    @Override
    public void sendmsg(PushlishBean pushlishBean) {
        long sequence = this.ringBuffer.next();
        PushlishBean pushlishBeanBuff = (PushlishBean)this.ringBuffer.get(sequence);
        try {
            BeanUtils.copyProperties((Object)pushlishBeanBuff, (Object)pushlishBean);
        }
        catch (Exception e) {
            e.printStackTrace();
            LoggerUtil.exit((JvmStatus)JvmStatus.s15);
        }
        this.ringBuffer.publish(sequence);
    }
}

