/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone.parser;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.TimeAssist;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.binlog.alone.BusiAssit;
import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.jmx.BinlogControl;
import net.wicp.tams.common.binlog.alone.parser.BaseLogFetcher;
import net.wicp.tams.common.binlog.parser.DirectLogFetcher;
import net.wicp.tams.common.binlog.parser.LogBuffer;
import net.wicp.tams.common.binlog.parser.LogContext;
import net.wicp.tams.common.binlog.parser.LogDecoder;
import net.wicp.tams.common.binlog.parser.LogEvent;
import net.wicp.tams.common.binlog.parser.event.DeleteRowsLogEvent;
import net.wicp.tams.common.binlog.parser.event.GtidLogEvent;
import net.wicp.tams.common.binlog.parser.event.QueryLogEvent;
import net.wicp.tams.common.binlog.parser.event.RotateLogEvent;
import net.wicp.tams.common.binlog.parser.event.RowsLogEvent;
import net.wicp.tams.common.binlog.parser.event.UpdateRowsLogEvent;
import net.wicp.tams.common.binlog.parser.event.WriteRowsLogEvent;
import net.wicp.tams.common.binlog.parser.event.XidLogEvent;
import net.wicp.tams.common.constant.DateFormatCase;
import net.wicp.tams.common.constant.DbType;
import net.wicp.tams.common.constant.JvmStatus;
import net.wicp.tams.common.constant.OptType;
import net.wicp.tams.common.jdbc.DruidAssit;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseLogOnline
extends BaseLogFetcher {
    private static final Logger log = LoggerFactory.getLogger(ParseLogOnline.class);
    private Connection conn;
    private static String uuid;
    private String slaveGtids;
    private boolean gtidCan;
    private ListenerConf.Position posPre;
    private DirectLogFetcher fecther;
    private ListenerConf.Position.Builder curpos;
    private ListenerConf.Position.Builder savepos;
    ScheduledExecutorService timerService;
    private final String configName;
    public static List<Thread> startThreadList;
    ScheduledFuture<?> scheduleAtFixedRate = null;
    private boolean isClose = false;

    public ParseLogOnline(ListenerConf.ConnConf.Builder connConfBuilder) {
        super(connConfBuilder);
        this.configName = connConfBuilder.getConfName();
        startThreadList.add(Thread.currentThread());
        this.addTimer();
        this.initMbean();
    }

    @Override
    protected void init(ListenerConf.ConnConf.Builder connConfBuilder) {
        switch (connConfBuilder.getHaType()) {
            case cur: {
                connConfBuilder.setPos(this.getMastStatus(connConfBuilder));
                break;
            }
            case pos: {
                if (connConfBuilder.hasPos()) break;
                throw new RuntimeException("hatype\u4e3apos\u7c7b\u578b\uff0c\u5374\u6ca1\u6709\u63d0\u4f9bgtid\u7b49\u4f4d\u7f6e\u4fe1\u606f\u3002");
            }
            case last: {
                ListenerConf.Position maxpoint = this.saveCheckPoint.findPoint(Long.MAX_VALUE);
                if (maxpoint == null) {
                    connConfBuilder.setPos(this.getMastStatus(connConfBuilder));
                    break;
                }
                connConfBuilder.setPos(maxpoint);
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684hatype\u3002");
            }
        }
        this.curpos = connConfBuilder.getPosBuilder().clone();
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (Exception e) {
            log.error("\u5173\u95ed\u94fe\u63a5\u5931\u8d25", (Throwable)e);
        }
        try {
            Class.forName("com.mysql.jdbc.Driver");
            this.conn = DriverManager.getConnection(DbType.mysql.geturl(connConfBuilder.getHost(), connConfBuilder.getPort()), connConfBuilder.getUsername(), connConfBuilder.getPassword());
            Statement statement = this.conn.createStatement();
            statement.execute("SET @master_binlog_checksum='@@global.binlog_checksum'");
            statement.execute("SET @mariadb_slave_capability='4'");
            statement.close();
            uuid = this.getVar(this.conn, "server_uuid", false);
            this.gtids = connConfBuilder.getPos().getGtids();
            this.fileName = connConfBuilder.getPos().getFileName();
            this.initSlaveGtids(connConfBuilder.getPos().getGtids());
            this.gtidCan = this.isAvailable(this.conn, connConfBuilder.getPos().getGtids(), uuid);
            log.info("gtid\uff1a[{}]\u662f\u5426\u53ef\u7528\uff1a[{}]", (Object)connConfBuilder.getPos().getGtids(), (Object)this.gtidCan);
        }
        catch (Exception e) {
            log.error("\u8bfbbinlog\u65e5\u5fd7\u51fa\u73b0\u95ee\u9898", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void addTimer() {
        this.timerService = Executors.newSingleThreadScheduledExecutor();
        this.scheduleAtFixedRate = this.timerService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    ParseLogOnline.this.savepos = ParseLogOnline.this.savepos == null ? ParseLogOnline.this.curpos.clone() : ParseLogOnline.this.savepos;
                    if (ParseLogOnline.this.savepos != null) {
                        ListenerConf.Position pos = ParseLogOnline.this.savepos.build();
                        ParseLogOnline.this.saveCheckPoint.savePoint(pos);
                    } else {
                        log.info("configName:{} pos is null", (Object)ParseLogOnline.this.configName);
                    }
                }
                catch (Throwable e) {
                    log.error("save point error:", e);
                }
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public boolean isClose() {
        return this.isClose;
    }

    @Override
    public void read() {
        while (!this.isClose) {
            try {
                this.readDo();
                TimeAssist.reDoWaitInit((String)"need-init");
            }
            catch (Throwable e) {
                boolean reDoWait = TimeAssist.reDoWait((String)"need-init", (int)8);
                log.error("readdo error", e);
                if (!reDoWait) continue;
                log.error("\u5df2\u91cd\u8bd58\u6b21\uff0c\u9000\u51fa\u7cfb\u7edf");
                LoggerUtil.exit((JvmStatus)JvmStatus.s15);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDo() {
        if (StringUtil.isNull((Object)this.connConf.getPos().getGtids()) && this.connConf.getPos().getPos() < 4L) {
            throw new IllegalAccessError("\u5f00\u59cb\u4f4d\u7f6e\u6700\u5c0f\u4e3a4");
        }
        Boolean needinit = (Boolean)PerthreadManager.getInstance().createValue((Object)"need-init", Boolean.class).get((Object)false);
        if (needinit.booleanValue()) {
            this.init(this.connConf.toBuilder());
        }
        this.fecther = new DirectLogFetcher();
        try {
            this.fetchLog();
            LogDecoder decoder = new LogDecoder(0, 164);
            LogContext context = new LogContext();
            boolean isSel = false;
            while (this.fecther.fetch()) {
                this.metric.meter_parser_pack_all.mark();
                LogEvent event = null;
                event = decoder.decode((LogBuffer)this.fecther, context);
                if (event == null) continue;
                int eventType = event.getHeader().getType();
                switch (eventType) {
                    case 15: {
                        break;
                    }
                    case 4: {
                        this.fileName = ((RotateLogEvent)event).getFilename();
                        this.packPos(event);
                        break;
                    }
                    case 23: 
                    case 30: {
                        if (this.gtids != null && this.parseRowsEvent((RowsLogEvent)((WriteRowsLogEvent)event), OptType.insert)) {
                            isSel = true;
                            this.savepos = this.curpos.clone();
                            break;
                        }
                        if (this.isChkDb) break;
                        this.savepos = null;
                        break;
                    }
                    case 24: 
                    case 31: {
                        if (this.gtids != null && this.parseRowsEvent((RowsLogEvent)((UpdateRowsLogEvent)event), OptType.update)) {
                            isSel = true;
                            this.savepos = this.curpos.clone();
                            break;
                        }
                        if (this.isChkDb) break;
                        this.savepos = null;
                        break;
                    }
                    case 25: 
                    case 32: {
                        if (this.gtids != null && this.parseRowsEvent((RowsLogEvent)((DeleteRowsLogEvent)event), OptType.delete)) {
                            isSel = true;
                            this.savepos = this.curpos.clone();
                            break;
                        }
                        if (this.isChkDb) break;
                        this.savepos = null;
                        break;
                    }
                    case 2: {
                        this.parseQueryEvent((QueryLogEvent)event);
                        this.packPos(event);
                        break;
                    }
                    case 16: {
                        if (this.gtids == null || !isSel) break;
                        this.parseXidEvent((XidLogEvent)event);
                        this.packPos(event);
                        isSel = false;
                        break;
                    }
                    case 33: {
                        this.parseGtidLogEvent((GtidLogEvent)event);
                        this.packPos(event);
                        break;
                    }
                }
            }
        }
        catch (SQLException e) {
            log.error("\u5f97\u5230\u8054\u63a5\u9519\u8bef", (Throwable)e);
        }
        catch (IOException e) {
            if (e.getMessage().contains("errno = 1236, sqlstate = HY000")) {
                // empty if block
            }
            log.error("\u62c9\u53d6\u65e5\u5fd7\u6587\u4ef6\u9519\u8bef", (Throwable)e);
        }
        catch (Throwable e) {
            log.error("\u672a\u77e5\u9519\u8bef", e);
        }
    }

    private Connection getConn() {
        while (true) {
            try {
                if (this.conn == null || this.conn.isClosed()) {
                    this.init(this.connConf.toBuilder());
                }
                TimeAssist.reDoWaitInit((String)"tams-binlog");
                return this.conn;
            }
            catch (Exception e) {
                log.error("\u5f97\u5230\u8fde\u63a5\u5931\u8d25", (Throwable)e);
                boolean reDoWait = TimeAssist.reDoWait((String)"tams-binlog", (int)5);
                if (!reDoWait) continue;
                try {
                    Thread.sleep(32000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    private void fetchLog() throws IOException, CloneNotSupportedException {
        boolean useGtid = true;
        boolean needSecond = false;
        try {
            if (this.gtidCan) {
                this.fecther.openGtid(this.getConn(), this.gtids, this.connConf.getClientId());
            } else {
                useGtid = false;
                this.fetchLogFroPos();
            }
        }
        catch (Exception e) {
            log.error("\u7b2c\u4e00\u6b21\u542f\u52a8\u5931\u8d25\uff0c\u4f7f\u7528gtid:" + useGtid, (Throwable)e);
            needSecond = true;
        }
        if (needSecond) {
            if (useGtid) {
                this.fetchLogFroPos();
            } else {
                this.fecther.openGtid(this.getConn(), this.gtids, this.connConf.getClientId());
            }
        }
    }

    private void fetchLogFroPos() throws IOException {
        long filePosition = this.connConf.getPos().getPos();
        if (this.posPre != null) {
            int upPos = 10000;
            filePosition = this.connConf.getPos().getPos() > (long)(upPos + 4) ? this.connConf.getPos().getPos() - (long)upPos : this.connConf.getPos().getPos();
            log.warn("\u5df2\u505a\u4e3b\u5907\u5207\u6362\uff0c\u4f46\u4e0d\u652f\u6301Gtid\uff0c\u91c7\u7528\u56de\u671410000\u4f4d\u70b9\u7684\u65b9\u5f0f");
        }
        this.fecther.open(this.getConn(), this.connConf.getPos().getFileName(), filePosition, this.connConf.getClientId());
    }

    @Override
    protected void parseGtidLogEventSub(GtidLogEvent event) {
        if (StringUtil.isNotNull((Object)uuid) && uuid.equals(event.getSource())) {
            if (StringUtil.isNotNull((Object)this.slaveGtids)) {
                this.gtids = String.format("%s,%s", this.gtids, this.slaveGtids);
            }
        } else {
            log.info("------------------\u505a\u4e3b\u5907\u5207\u6362,\u539f\u4e3b\u673a\u6e90[{}],\u5207\u6362\u6e90[{}}]--------------------------------", (Object)uuid, (Object)event.getSource());
            this.gtids = null;
        }
    }

    private void packPos(LogEvent event) {
        this.curpos.setGtids(this.gtids);
        this.curpos.setPos(event.getLogPos());
        long time = event.getHeader().getWhen() * 1000L;
        this.curpos.setTime(time);
        this.curpos.setTimeStr(DateFormatCase.YYYY_MM_DD_hhmmss.getInstanc().format(time));
        this.curpos.setServerIp(this.connConf.getHost());
        this.curpos.setClintId(this.connConf.getClientId());
        this.curpos.setFileName(this.fileName);
    }

    public ListenerConf.Position getCurpos() {
        return this.savepos == null ? this.curpos.build() : this.savepos.build();
    }

    public ListenerConf.CheckPoint getCheckPointCur() {
        ListenerConf.Position curpos = this.getCurpos();
        return this.getCheckPoint(curpos);
    }

    public ListenerConf.CheckPoint getCheckPoint(long time) {
        ListenerConf.Position findTime = this.saveCheckPoint.findPoint(time);
        return this.getCheckPoint(findTime);
    }

    public void setColHis(List<ListenerConf.ColHis> colHisList) {
        if (CollectionUtils.isEmpty(colHisList)) {
            return;
        }
        for (ListenerConf.ColHis colHis : colHisList) {
            String key = BusiAssit.getColHiskey(colHis.getDb(), colHis.getTb());
            if (this.colsMap.containsKey(key)) {
                List<ListenerConf.ColHis> list = this.colsMap.get(key);
                boolean has = false;
                for (ListenerConf.ColHis ele : list) {
                    if (ele.getTime() != colHis.getTime()) continue;
                    has = true;
                    break;
                }
                if (has) continue;
                list.add(colHis);
                continue;
            }
            ArrayList<ListenerConf.ColHis> templist = new ArrayList<ListenerConf.ColHis>();
            templist.add(colHis);
            this.colsMap.put(key, templist);
        }
        for (ListenerConf.ColHis colHis2 : colHisList) {
            this.saveCheckPoint.saveColName(colHis2);
        }
        for (String key : this.colsMap.keySet()) {
            if (this.colsMap.get(key).size() < 2) continue;
            Collections.sort(this.colsMap.get(key), new Comparator<ListenerConf.ColHis>(){

                @Override
                public int compare(ListenerConf.ColHis o1, ListenerConf.ColHis o2) {
                    long def = o2.getTime() - o1.getTime();
                    return def > 0L ? 1 : (def < 0L ? -1 : 0);
                }
            });
        }
    }

    private ListenerConf.CheckPoint getCheckPoint(ListenerConf.Position findPoint) {
        List colsList = this.saveCheckPoint.findColsAll();
        ListenerConf.CheckPoint.Builder checkPointBuilder = ListenerConf.CheckPoint.newBuilder();
        checkPointBuilder.setPos(findPoint);
        checkPointBuilder.addAllCols((Iterable)colsList);
        return checkPointBuilder.build();
    }

    @Override
    public void close() {
        this.isClose = true;
        if (this.savepos != null) {
            this.saveCheckPoint.savePoint(this.savepos.build());
        }
        try {
            if (this.scheduleAtFixedRate != null) {
                this.scheduleAtFixedRate.cancel(true);
            }
            log.info("============1close timerService Thread sucess");
            if (this.timerService != null) {
                this.timerService.shutdown();
                log.info("============2close timerService pool sucess");
            }
        }
        catch (Throwable e) {
            log.error("\u5173\u95ed\u5b9a\u65f6\u5668\u5931\u8d25", e);
        }
        try {
            this.buffType.getBinlogListenerProxy().close();
            log.info("============3close BinlogListener2 sucess");
        }
        catch (Throwable e) {
            log.error("\u5173\u95ed\u76d1\u542c\u8005\u5931\u8d25", e);
        }
        if (this.fecther != null) {
            try {
                this.fecther.close();
                log.info("============4close fecther sucess");
            }
            catch (Throwable e) {
                log.error("\u5173\u95edfecther\u5931\u8d25", e);
            }
        }
        try {
            this.saveCheckPoint.releaseLock();
        }
        catch (Exception e) {
            log.error("\u91ca\u653e\u5206\u5e03\u5f0f\u9501\u5931\u8d25", (Throwable)e);
        }
    }

    public String getVar(Connection conn, String var, boolean isGlobal) throws SQLException {
        String sql = String.format("select @@%s%s", isGlobal ? "GLOBAL." : "", var);
        ResultSet resultSet = JdbcAssit.querySql((Connection)conn, (String)sql);
        resultSet.next();
        String retstr = resultSet.getString(1);
        resultSet.close();
        return retstr;
    }

    public boolean isAvailable(Connection conn, String gtidStr, String uuid) throws SQLException {
        if (StringUtil.isNull((Object)gtidStr)) {
            return false;
        }
        long maxGtidDel = this.maxGtid(this.getVar(conn, "GTID_PURGED", true), uuid);
        long maxGtidCur = this.maxGtid(gtidStr.replace("\n", ""), uuid);
        return maxGtidDel == 0L || maxGtidDel > 0L && maxGtidCur > 0L && maxGtidCur > maxGtidDel;
    }

    private long maxGtid(String gtidStr, String uuid) {
        if (StringUtil.isNull((Object)gtidStr)) {
            return 0L;
        }
        String[] gtidAry = gtidStr.split(",");
        long delmax = 0L;
        for (String eleGtid : gtidAry) {
            if (!eleGtid.startsWith(uuid)) continue;
            int index1 = eleGtid.lastIndexOf(":");
            String[] nums = eleGtid.substring(index1 + 1).split("-");
            String delNumStr = nums.length > 1 ? nums[1] : nums[0];
            delmax = Long.parseLong(delNumStr);
            break;
        }
        return delmax;
    }

    private void initSlaveGtids(String gtids) {
        if (StringUtil.isNotNull((Object)gtids)) {
            Object[] gtidsAry;
            this.gtids = gtids.replace("\n", "");
            for (String string : gtidsAry = this.gtids.split(",")) {
                if (!string.startsWith(uuid)) continue;
                gtidsAry = (String[])ArrayUtils.removeElement((Object[])gtidsAry, (Object)string);
                break;
            }
            this.slaveGtids = CollectionUtil.arrayJoin((Object[])gtidsAry, (String)",");
        }
    }

    private ListenerConf.Position getMastStatus(ListenerConf.ConnConf.Builder connConfBuilder) {
        Connection conn = DruidAssit.getConnection((String)connConfBuilder.getConfName());
        try {
            ListenerConf.Position.Builder mastStatus = DuckulaAssit.getMastStatus((Connection)conn);
            mastStatus.setServerIp(connConfBuilder.getHost());
            mastStatus.setClintId(connConfBuilder.getClientId());
            ListenerConf.Position position = mastStatus.build();
            return position;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void initMbean() {
        BinlogControl control = new BinlogControl(this);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(control, new ObjectName("net.wicp.tams.duckula:service=Task,name=DuckulaTask" + this.connConf.getConfName()));
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            throw new RuntimeException("\u521b\u5efaJMXBean\u5931\u8d25", e);
        }
        log.info("----------------------MBean[" + this.connConf.getConfName() + "]\u6ce8\u518c\u6210\u529f-------------------------------------");
    }

    static {
        startThreadList = new ArrayList<Thread>();
    }
}

