/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone.parser;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.apiext.PwdUtil;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.UUIDGenerator;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.PluginAssit;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleManager;
import net.wicp.tams.common.binlog.alone.binlog.listener.IBinlogListener;
import net.wicp.tams.common.binlog.alone.binlog.listener.ISaveCheckPoint;
import net.wicp.tams.common.binlog.alone.constant.BuffType;
import net.wicp.tams.common.binlog.alone.constant.BusiAdapt;
import net.wicp.tams.common.binlog.alone.parser.BinlogMetricGroup;
import net.wicp.tams.common.binlog.parser.event.GtidLogEvent;
import net.wicp.tams.common.binlog.parser.event.QueryLogEvent;
import net.wicp.tams.common.binlog.parser.event.RowsLogBuffer;
import net.wicp.tams.common.binlog.parser.event.RowsLogEvent;
import net.wicp.tams.common.binlog.parser.event.TableMapLogEvent;
import net.wicp.tams.common.binlog.parser.event.XidLogEvent;
import net.wicp.tams.common.constant.DateFormatCase;
import net.wicp.tams.common.constant.JvmStatus;
import net.wicp.tams.common.constant.OptType;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.jdbc.DruidAssit;
import net.wicp.tams.common.jdbc.MySqlAssitExt;
import net.wicp.tams.common.jdbc.beans.AlterDbInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseLogFetcher {
    private static final Logger log = LoggerFactory.getLogger(BaseLogFetcher.class);
    protected String fileName = "mysql-bin.000001";
    protected Charset charset = Charset.forName("utf-8");
    protected String gtids;
    protected final ListenerConf.ConnConf connConf;
    protected final RuleManager ruleManager;
    protected final BinlogMetricGroup metric;
    protected final BuffType buffType;
    protected ISaveCheckPoint saveCheckPoint;
    protected final Map<String, List<ListenerConf.ColHis>> colsMap = new HashMap<String, List<ListenerConf.ColHis>>();
    protected long xid;
    protected boolean isChkDb = false;

    protected BaseLogFetcher(ListenerConf.ConnConf.Builder connConfBuilder) {
        Validate.notBlank((CharSequence)connConfBuilder.getConfName(), (String)"\u9700\u8981\u914d\u7f6e\u6587\u4ef6\u540d\uff0c\u5982\uff1adefault", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)connConfBuilder.getHost(), (String)"\u9700\u8981ip\u5730\u5740", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)connConfBuilder.getUsername(), (String)"\u9700\u8981\u7528\u6237\u540d", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)connConfBuilder.getPassword(), (String)"\u9700\u8981\u5bc6\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)connConfBuilder.getListener(), (String)"\u9700\u8981\u5904\u7406\u7684\u76d1\u542c\u7c7b", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)connConfBuilder.getRule(), (String)"\u9700\u8981\u76d1\u542c\u89c4\u5219", (Object[])new Object[0]);
        if (connConfBuilder.getPort() <= 0) {
            connConfBuilder.setPort(3306);
        }
        if (connConfBuilder.getClientId() <= 0) {
            connConfBuilder.setClientId(StringUtil.buildPort((String)new UUIDGenerator().generate()));
        }
        Properties props = new Properties();
        props.put(String.format("common.jdbc.datasource.%s.host", connConfBuilder.getConfName()), connConfBuilder.getHost());
        props.put(String.format("common.jdbc.datasource.%s.port", connConfBuilder.getConfName()), (Object)connConfBuilder.getPort());
        props.put(String.format("common.jdbc.datasource.%s.username", connConfBuilder.getConfName()), connConfBuilder.getUsername());
        props.put(String.format("common.jdbc.datasource.%s.password", connConfBuilder.getConfName()), connConfBuilder.getPassword());
        Conf.overProp((Properties)props);
        this.ruleManager = new RuleManager(connConfBuilder.getRule());
        try {
            this.saveCheckPoint = (ISaveCheckPoint)Class.forName(connConfBuilder.getChk()).newInstance();
            this.saveCheckPoint.init(connConfBuilder);
        }
        catch (Exception e1) {
            log.error("\u521b\u5efacheckpoint\u5b9e\u4f8b\u5931\u8d25", (Throwable)e1);
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.project_other, "\u521b\u5efacheckpoint\u5b9e\u4f8b\u5931\u8d25");
        }
        this.init(connConfBuilder);
        YesOrNo acquireLock = this.saveCheckPoint.acquireLock();
        if (acquireLock == null || acquireLock == YesOrNo.no) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.project_other, "\u4e0d\u80fd\u83b7\u5f97\u5206\u5e03\u5f0f\u9501");
        }
        this.connConf = connConfBuilder.build();
        this.metric = new BinlogMetricGroup(String.format("%s:%s", this.connConf.getHost(), this.connConf.getPort()));
        IBinlogListener binlogListener = null;
        Class<?> busierClass = null;
        try {
            ClassLoader classloadertrue = Conf.pluginClassLoader((String)"common.binlog.alone.binlog.global.busiPluginDir");
            Class<?> binlogListenerClass = classloadertrue.loadClass(this.connConf.getListener());
            if (!ReflectAssist.isInterface(binlogListenerClass, (String)"net.wicp.tams.common.binlog.alone.binlog.listener.IBinlogListener")) {
                log.error("Listener\u9700\u8981net.wicp.tams.common.binlog.alone.binlog.listener.IBinlogListener\u7c7b\u578b");
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.Param_typenofit, "Listener\u9700\u8981net.wicp.tams.common.binlog.alone.binlog.listener.IBinlogListener\u7c7b\u578b");
            }
            try {
                binlogListener = (IBinlogListener)ReflectAssist.newInst(binlogListenerClass);
                binlogListener.init(this.connConf);
            }
            catch (Exception e1) {
                log.error("Listener\u5b9e\u4f8b\u5316\u5931\u8d25", (Throwable)e1);
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.Param_typenofit, "Listener\u5b9e\u4f8b\u5316\u5931\u8d25");
            }
            if (StringUtil.isNotNull((Object)this.connConf.getBusier())) {
                String[] ary = this.connConf.getBusier().split("\\|");
                busierClass = classloadertrue.loadClass(ary[0]);
                if (ary.length > 1) {
                    BusiAdapt.setCusClassName(busierClass, Integer.parseInt(ary[1]));
                } else {
                    BusiAdapt.setCusClassName(busierClass);
                }
            }
        }
        catch (ClassNotFoundException e) {
            log.error("\u6ca1\u6709\u6307\u5b9a\u7684Listener");
            LoggerUtil.exit((JvmStatus)JvmStatus.s15);
        }
        catch (Throwable e) {
            log.error("\u52a0\u8f7dlistener\u9519\u8bef", e);
            LoggerUtil.exit((JvmStatus)JvmStatus.s15);
        }
        String bufferstr = Conf.get((String)"common.binlog.alone.binlog.global.bufferType");
        this.buffType = BuffType.get(StringUtil.trimSpace((String)bufferstr));
        this.buffType.getBinlogListenerProxy().putIBinlogListener(this.connConf.getHost(), binlogListener);
        this.buffType.getBinlogListenerProxy().putBusiDowithAdapt(this.connConf);
    }

    protected void parseQueryEvent(QueryLogEvent event) {
        String db = event.getDbName();
        String sql = event.getQuery().toLowerCase();
        if (sql.startsWith("alter")) {
            try {
                AlterDbInfo info = MySqlAssitExt.parseAlterSql((String)sql);
                Rule findRule = this.ruleManager.findRule(db, info.getTb());
                if (findRule == null) {
                    return;
                }
                ListenerConf.ColHis findCols = this.findCols(db, info.getTb(), event.getWhen());
                Result tableCallBack = this.buffType.getBinlogListenerProxy().getIBinlogListener(this.connConf.getHost()).doAlterTableCallBack(findRule, findCols, sql, info.getAddColNames(), info.getUpdateColName(), info.getDeleteColNames());
                if (tableCallBack != null && !tableCallBack.isSuc()) {
                    String msg = "\u63d2\u4ef6\u56de\u8c03\u670d\u52a1\u5931\u8d25:" + tableCallBack.getMessage();
                    log.error(msg);
                    throw new RuntimeException(msg);
                }
            }
            catch (Exception e) {
                log.error("get tb from sql error", (Throwable)e);
            }
        }
    }

    protected void parseGtidLogEvent(GtidLogEvent event) throws Exception {
        this.gtids = event.getGtid();
        this.parseGtidLogEventSub(event);
    }

    protected abstract void parseGtidLogEventSub(GtidLogEvent var1);

    protected abstract void init(ListenerConf.ConnConf.Builder var1);

    public abstract void close();

    public abstract void read();

    protected void parseXidEvent(XidLogEvent event) {
        this.xid = event.getXid();
    }

    protected boolean parseRowsEvent(RowsLogEvent event, OptType optType) {
        int i;
        Rule findRule;
        if (log.isDebugEnabled()) {
            Date d = new Date(event.getHeader().getWhen() * 1000L);
            String datestr = DateFormatCase.YYYY_MM_DD_hhmmss.getInstanc().format(d);
            log.debug("db:{},tb:{},time:{}", new Object[]{event.getTable().getDbName(), event.getTable().getTableName(), datestr});
        }
        if ((findRule = this.ruleManager.findRule(event.getTable().getDbName(), event.getTable().getTableName())) == null) {
            return false;
        }
        this.metric.meter_parser_pack_row.mark();
        ListenerConf.ColHis colhis = this.ValidKey(event.getTable().getDbName(), event.getTable().getTableName(), event.getWhen());
        ArrayList<String[]> rowListBefore = new ArrayList<String[]>();
        ArrayList<String[]> rowListAfter = new ArrayList<String[]>();
        int rows = 0;
        try {
            RowsLogBuffer buffer = event.getRowsBuf(this.charset.name());
            BitSet columns = event.getColumns();
            BitSet changeColumns = event.getChangeColumns();
            while (buffer.nextOneRow(columns)) {
                Pair<String[], Boolean> parseOneRow;
                int type = event.getHeader().getType();
                if (23 == type || 30 == type) {
                    parseOneRow = this.parseOneRow(event, buffer, columns, colhis.getColsCount(), true);
                    rowListAfter.add((String[])parseOneRow.getLeft());
                    if (((Boolean)parseOneRow.getRight()).booleanValue()) {
                        colhis = this.ValidKey(event.getTable().getDbName(), event.getTable().getTableName(), event.getWhen());
                    }
                } else if (25 == type || 32 == type) {
                    parseOneRow = this.parseOneRow(event, buffer, columns, colhis.getColsCount(), false);
                    rowListBefore.add((String[])parseOneRow.getLeft());
                    if (((Boolean)parseOneRow.getRight()).booleanValue()) {
                        colhis = this.ValidKey(event.getTable().getDbName(), event.getTable().getTableName(), event.getWhen());
                    }
                } else {
                    parseOneRow = this.parseOneRow(event, buffer, columns, colhis.getColsCount(), true);
                    rowListBefore.add((String[])parseOneRow.getLeft());
                    if (((Boolean)parseOneRow.getRight()).booleanValue()) {
                        colhis = this.ValidKey(event.getTable().getDbName(), event.getTable().getTableName(), event.getWhen());
                    }
                    if (!buffer.nextOneRow(changeColumns)) break;
                    rowListAfter.add((String[])this.parseOneRow(event, buffer, changeColumns, colhis.getColsCount(), true).getLeft());
                }
                ++rows;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("parse row data failed.", e);
        }
        String[][] afterArray = new String[rowListAfter.size()][];
        for (int i2 = 0; i2 < rowListAfter.size(); ++i2) {
            afterArray[i2] = (String[])rowListAfter.get(i2);
        }
        String[][] beforeArray = new String[rowListBefore.size()][];
        for (int i3 = 0; i3 < rowListBefore.size(); ++i3) {
            beforeArray[i3] = (String[])rowListBefore.get(i3);
        }
        ListenerConf.DuckulaEvent.Builder duckulaEventBuilder = ListenerConf.DuckulaEvent.newBuilder();
        duckulaEventBuilder.setColNum(ArrayUtils.isNotEmpty((Object[])afterArray) ? afterArray[0].length : beforeArray[0].length);
        duckulaEventBuilder.addAllCols((Iterable)colhis.getColsList());
        TableMapLogEvent.ColumnInfo[] colsColumnInfo = event.getTable().getColumnInfo();
        for (i = 0; i < colsColumnInfo.length; ++i) {
            duckulaEventBuilder.addColsTypeValue(colsColumnInfo[i].type);
        }
        duckulaEventBuilder.setDb(event.getTable().getDbName());
        duckulaEventBuilder.setTb(event.getTable().getTableName());
        duckulaEventBuilder.setGtid(this.gtids);
        duckulaEventBuilder.setIsError(false);
        duckulaEventBuilder.setOptType(ListenerConf.OptType.forNumber((int)optType.getValue()));
        duckulaEventBuilder.setCommitTime(event.getWhen() * 1000L);
        for (i = 0; i < rows; ++i) {
            ListenerConf.DuckulaEventItem.Builder newBuilder = ListenerConf.DuckulaEventItem.newBuilder();
            this.initData(newBuilder, rowListBefore, (List<String>)colhis.getColsList(), i, false);
            this.initData(newBuilder, rowListAfter, (List<String>)colhis.getColsList(), i, true);
            duckulaEventBuilder.addItems(newBuilder);
        }
        this.buffType.getBinlogListenerProxy().sendmsg(this.connConf.getHost(), findRule, duckulaEventBuilder);
        this.metric.meter_parser_event.mark((long)rows);
        this.metric.counter_ringbuff_pack.inc();
        this.metric.counter_ringbuff_event.inc((long)rows);
        return true;
    }

    protected Pair<String[], Boolean> parseOneRow(RowsLogEvent event, RowsLogBuffer buffer, BitSet cols, int colNum, boolean isAfter) throws UnsupportedEncodingException {
        TableMapLogEvent map = event.getTable();
        if (map == null) {
            throw new RuntimeException("not found TableMap with tid=" + event.getTableId());
        }
        boolean needReloadColName = false;
        if (colNum != event.getTable().getColumnCnt()) {
            ListenerConf.ColHis colhis = this.findCols(event.getTable().getDbName(), event.getTable().getTableName(), event.getWhen());
            if (colhis.getColsCount() != event.getTable().getColumnCnt()) {
                throw new RuntimeException("TableMap:" + event.getTableId() + " the colsname is:" + colhis.getColsCount() + " the value size is:" + event.getTable().getColumnCnt());
            }
            String key = String.format("%s|%s", event.getTable().getDbName(), event.getTable().getTableName()).toLowerCase();
            this.colsMap.remove(key);
            needReloadColName = true;
        }
        String[] values = new String[event.getTable().getColumnCnt()];
        int columnCnt = map.getColumnCnt();
        TableMapLogEvent.ColumnInfo[] columnInfo = map.getColumnInfo();
        for (int i = 0; i < columnCnt; ++i) {
            if (!cols.get(i)) continue;
            TableMapLogEvent.ColumnInfo info = columnInfo[i];
            buffer.nextValue(info.type, info.meta);
            if (buffer.isNull()) continue;
            Serializable value = buffer.getValue();
            values[i] = value instanceof byte[] ? PwdUtil.base64FromBin((byte[])((byte[])value)) : String.valueOf(value);
        }
        return Pair.of((Object)values, (Object)needReloadColName);
    }

    public ListenerConf.ColHis findCols(String db, String tb, long time) {
        String key = String.format("%s|%s", db, tb).toLowerCase();
        Connection conn = null;
        try {
            conn = DruidAssit.getConnection((String)this.connConf.getConfName());
            List colList = MySqlAssit.getColsNew((Connection)conn, (String)db, (String)tb, (YesOrNo)(this.connConf.getRds() ? YesOrNo.yes : YesOrNo.no));
            ListenerConf.ColHis retobj = PluginAssit.convertCosHis((String)this.connConf.getHost(), (String)db, (String)tb, (long)time, (List)colList);
            this.saveCheckPoint.saveColName(retobj);
            List findColsList = this.saveCheckPoint.findColsList(db, tb);
            Collections.sort(findColsList, new Comparator<ListenerConf.ColHis>(){

                @Override
                public int compare(ListenerConf.ColHis o1, ListenerConf.ColHis o2) {
                    long def = o2.getTime() - o1.getTime();
                    return def > 0L ? 1 : (def < 0L ? -1 : 0);
                }
            });
            this.colsMap.put(key, findColsList);
            ListenerConf.ColHis colHis = retobj;
            return colHis;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6cols\u9519\u8bef", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6cols\u9519\u8bef");
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    log.error("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    public ListenerConf.ColHis ValidKey(String db, String tb, long time) {
        String key = String.format("%s|%s", db, tb).toLowerCase();
        if (this.colsMap.containsKey(key)) {
            List<ListenerConf.ColHis> list = this.colsMap.get(key);
            ListenerConf.ColHis selFitColName = this.selFitColName(time, list);
            if (selFitColName == null) {
                throw new RuntimeException("\u6ca1\u6709\u53ef\u7528\u7684col\u4fe1\u606f\u3002");
            }
            return selFitColName;
        }
        List findColsList = this.saveCheckPoint.findColsList(db, tb);
        if (CollectionUtils.isEmpty((Collection)findColsList)) {
            ListenerConf.ColHis retobj = this.findCols(db, tb, -1L);
            ArrayList<ListenerConf.ColHis> retlist = new ArrayList<ListenerConf.ColHis>();
            retlist.add(retobj);
            this.colsMap.put(key, retlist);
            return retobj;
        }
        Collections.sort(findColsList, new Comparator<ListenerConf.ColHis>(){

            @Override
            public int compare(ListenerConf.ColHis o1, ListenerConf.ColHis o2) {
                long def = o2.getTime() - o1.getTime();
                return def > 0L ? 1 : (def < 0L ? -1 : 0);
            }
        });
        this.colsMap.put(key, findColsList);
        ListenerConf.ColHis selFitColName = this.selFitColName(time, findColsList);
        if (selFitColName == null) {
            throw new RuntimeException("\u6ca1\u6709\u53ef\u7528\u7684col\u4fe1\u606f\u3002");
        }
        return selFitColName;
    }

    private ListenerConf.ColHis selFitColName(long time, List<ListenerConf.ColHis> list) {
        for (int i = 0; i < list.size(); ++i) {
            ListenerConf.ColHis colHis = list.get(i);
            if (colHis.getTime() > time) continue;
            return colHis;
        }
        return null;
    }

    private void initData(ListenerConf.DuckulaEventItem.Builder rowbuilder, List<String[]> datas, List<String> cols, int rowNo, boolean isAfter) {
        if (CollectionUtils.isEmpty(datas)) {
            return;
        }
        String[] tempary = datas.get(rowNo);
        for (int i = 0; i < tempary.length; ++i) {
            if (tempary[i] == null) continue;
            if (isAfter) {
                rowbuilder.putAfter(cols.get(i), tempary[i]);
                continue;
            }
            rowbuilder.putBefore(cols.get(i), tempary[i]);
        }
    }

    public BuffType getBuffType() {
        return this.buffType;
    }
}

