/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone.constant;

import java.util.HashMap;
import java.util.Map;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.apiext.MaxSizeHashMap;
import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.beans.RingBuffMonitor;
import net.wicp.tams.common.binlog.alone.binlog.bean.PushlishBean;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.listener.AbsBusi;
import net.wicp.tams.common.binlog.alone.binlog.listener.IBinlogListener;
import net.wicp.tams.common.binlog.alone.constant.BusiAdapt;
import net.wicp.tams.common.constant.JvmStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BuffType {
    disruptor("\u5168\u5c40\u6709\u5e8f", "net.wicp.tams.common.binlog.alone.proxy.Disruptor"),
    threadpoolsingle("\u4e0d\u4fdd\u8bc1\u987a\u5e8f", "net.wicp.tams.common.binlog.alone.proxy.Threadpoolsingle"),
    threadpoolmuli("\u6761\u4ef6\u987a\u5e8f", "net.wicp.tams.common.binlog.alone.proxy.Threadpoolmuli"),
    no("\u4e0d\u4f7f\u7528\u52a0\u901f\u5668", "net.wicp.tams.common.binlog.alone.proxy.No");

    private static final Logger log;
    private final String desc;
    private final String binlogListenerProxyClass;
    private BinlogListenerProxy binlogListenerProxy;

    public BinlogListenerProxy getBinlogListenerProxy() {
        if (this.binlogListenerProxy == null) {
            try {
                this.binlogListenerProxy = (BinlogListenerProxy)Class.forName(this.binlogListenerProxyClass).newInstance();
            }
            catch (Exception e) {
                log.error("\u521b\u5efa\u4ee3\u7406\u7c7b\u5931\u8d25", (Throwable)e);
                LoggerUtil.exit((JvmStatus)JvmStatus.s15);
            }
        }
        return this.binlogListenerProxy;
    }

    private BuffType(String desc, String binlogListenerProxyClass) {
        this.desc = desc;
        this.binlogListenerProxyClass = binlogListenerProxyClass;
    }

    public static BuffType get(String name) {
        for (BuffType checksum : BuffType.values()) {
            if (!checksum.name().equalsIgnoreCase(name)) continue;
            return checksum;
        }
        return no;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        log = LoggerFactory.getLogger(BuffType.class);
    }

    public static abstract class BinlogListenerProxy {
        private final Map<String, IBinlogListener> listermap = new HashMap<String, IBinlogListener>();
        private final Map<String, AbsBusi> doWithMap = new HashMap<String, AbsBusi>();
        private volatile MaxSizeHashMap<String, Long> versionMap = new MaxSizeHashMap(10000);

        public void putIBinlogListener(String host, IBinlogListener binlogListener) {
            this.listermap.put(host, binlogListener);
        }

        public IBinlogListener getIBinlogListener(String host) {
            return this.listermap.get(host);
        }

        public synchronized void putBusiDowithAdapt(ListenerConf.ConnConf connConf) {
            AbsBusi innerBusis = BusiAdapt.putInnerBusis(connConf);
            this.doWithMap.put(connConf.getHost(), innerBusis);
        }

        protected abstract void sendmsg(PushlishBean var1);

        public final void sendmsg(String host, Rule rule, ListenerConf.DuckulaEvent.Builder duckulaEventBuilder) {
            PushlishBean pushlishBean = new PushlishBean();
            pushlishBean.setRule(rule);
            pushlishBean.setEventBuilder(duckulaEventBuilder);
            pushlishBean.setBinlogListener(this.listermap.get(host));
            pushlishBean.setBusiListener(this.doWithMap.get(host));
            pushlishBean.setVersionMap(this.versionMap);
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < duckulaEventBuilder.getItemsCount(); ++i) {
                ListenerConf.DuckulaEventItem.Builder duckulaEventItem = duckulaEventBuilder.getItemsBuilder(i);
                String key = DuckulaAssit.getKeyJoin((ListenerConf.DuckulaEvent.Builder)duckulaEventBuilder, (int)i, (String)"`");
                String idstr = String.valueOf(key);
                buff.append(idstr);
                buff.append(",");
                long logicDotrans = duckulaEventBuilder.getCommitTime();
                if (this.versionMap.containsKey((Object)idstr)) {
                    if ((Long)this.versionMap.get((Object)idstr) / 1000L == logicDotrans / 1000L) {
                        logicDotrans = (Long)this.versionMap.get((Object)idstr) + 1L;
                        this.versionMap.put((Object)idstr, (Object)logicDotrans);
                    } else {
                        this.versionMap.put((Object)idstr, (Object)logicDotrans);
                    }
                } else {
                    this.versionMap.put((Object)idstr, (Object)logicDotrans);
                }
                duckulaEventItem.setVersion(logicDotrans);
            }
            log.info("sendmsg table:{} count:{} ids:{}", new Object[]{pushlishBean.getEventBuilder().getTb(), pushlishBean.getEventBuilder().getItemsCount(), buff.toString()});
            this.sendmsg(pushlishBean);
        }

        public abstract RingBuffMonitor getCurDoWithSize();

        public abstract void close();
    }
}

