/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone.checkpoint;

import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.PluginAssit;
import net.wicp.tams.common.binlog.alone.binlog.listener.ISaveCheckPoint;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.others.ZkClient;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckPointZookeeper
implements ISaveCheckPoint {
    private static final Logger log = LoggerFactory.getLogger(CheckPointZookeeper.class);
    private ListenerConf.ConnConf connConf;
    private final String defaultRootpath = "/duckula3";
    private final String defaultPositionpath = "pos";
    private final String defaultColpath = "cols";
    private final String defaultLockpath = "lock";
    private String rootPath = "/duckula3";
    private String pospath = null;
    private String colspath = null;
    private String lockpath = null;
    private InterProcessMutex lock;

    public void init(ListenerConf.ConnConf.Builder connConfBuilder) {
        String constr = Conf.get((String)"common.others.zookeeper.constr");
        log.info("the constr is:{}", (Object)constr);
        if (StringUtil.isNull((Object)Conf.get((String)"common.binlog.alone.binlog.global.chk.zookeeper.rootpath"))) {
            log.warn("please set the common.binlog.alone.binlog.global.chk.zookeeper.rootpath ,the default rootpath '{}' is used.", (Object)"/duckula3");
        } else {
            this.rootPath = Conf.get((String)"common.binlog.alone.binlog.global.chk.zookeeper.rootpath");
        }
        this.pospath = IOUtil.mergeFolderAndFilePath((String)this.rootPath, (String[])new String[]{connConfBuilder.getHost(), this.defaultPositionpath});
        ZkClient.getInst().createMultilevelNode(this.pospath);
        this.colspath = IOUtil.mergeFolderAndFilePath((String)this.rootPath, (String[])new String[]{connConfBuilder.getHost(), this.defaultColpath});
        ZkClient.getInst().createMultilevelNode(this.colspath);
        this.lockpath = IOUtil.mergeFolderAndFilePath((String)this.rootPath, (String[])new String[]{connConfBuilder.getHost(), this.defaultLockpath, connConfBuilder.getGroupId()});
        ZkClient.getInst().createMultilevelNode(this.lockpath);
        this.connConf = connConfBuilder.build();
    }

    public void shutdown() {
        log.info("the connection is closed");
    }

    public void savePoint(ListenerConf.Position pos) {
        ZkClient.getInst().createOrUpdateNodeForJson(IOUtil.mergeFolderAndFilePath((String)this.pospath, (String[])new String[]{String.valueOf(pos.getTime())}), (Object)PluginAssit.toJsonStr((Message)pos));
        log.info("\u4fdd\u5b58\u5b9e\u4f8b:{} \u4f4d\u70b9{}\u6210\u529f", (Object)pos.getServerIp(), (Object)pos.getGtids());
    }

    public void saveColName(ListenerConf.ColHis colHis) {
        ZkClient.getInst().createOrUpdateNodeForJson(IOUtil.mergeFolderAndFilePath((String)this.colspath, (String[])new String[]{colHis.getDb(), colHis.getTb(), String.valueOf(colHis.getTime())}), (Object)PluginAssit.toJsonStr((Message)colHis));
        log.info("\u4fdd\u5b58\u5b57\u6bb5\u540d\u6210\u529f,db{},tb{},time{}", new Object[]{colHis.getDb(), colHis.getTb(), colHis.getTime()});
    }

    public ListenerConf.Position findPoint(long time) {
        List times = ZkClient.getInst().getChildren(IOUtil.mergeFolderAndFilePath((String)this.pospath, (String[])new String[0]));
        long cur = -1L;
        for (String timestr : times) {
            long eletime = Long.parseLong(timestr);
            if (eletime > time) continue;
            if (cur == -1L) {
                cur = eletime;
                continue;
            }
            if (eletime <= cur) continue;
            cur = eletime;
        }
        if (cur == -1L) {
            return null;
        }
        String jsonstr = ZkClient.getInst().getZkDataStr(IOUtil.mergeFolderAndFilePath((String)this.pospath, (String[])new String[]{String.valueOf(cur)}));
        ListenerConf.Position dateObj = (ListenerConf.Position)PluginAssit.toMessage((String)jsonstr, ListenerConf.Position.class);
        return dateObj;
    }

    public List<ListenerConf.ColHis> findColsList(String db, String tb) {
        ArrayList<ListenerConf.ColHis> retlist = new ArrayList<ListenerConf.ColHis>();
        String parentPath = IOUtil.mergeFolderAndFilePath((String)this.colspath, (String[])new String[]{db, tb});
        Stat exists = ZkClient.getInst().exists(parentPath);
        if (exists == null) {
            ZkClient.getInst().createMultilevelNode(parentPath);
            return retlist;
        }
        List times = ZkClient.getInst().getChildren(parentPath);
        for (String timestr : times) {
            String jsonstr = ZkClient.getInst().getZkDataStr(IOUtil.mergeFolderAndFilePath((String)this.colspath, (String[])new String[]{db, tb, timestr}));
            ListenerConf.ColHis dateObj = (ListenerConf.ColHis)PluginAssit.toMessage((String)jsonstr, ListenerConf.ColHis.class);
            retlist.add(dateObj);
        }
        return retlist;
    }

    public List<ListenerConf.ColHis> findColsAll() {
        ArrayList<ListenerConf.ColHis> retlist = new ArrayList<ListenerConf.ColHis>();
        List dbs = ZkClient.getInst().getChildren(IOUtil.mergeFolderAndFilePath((String)this.colspath, (String[])new String[]{this.connConf.getHost()}));
        for (String db : dbs) {
            List tbs = ZkClient.getInst().getChildren(IOUtil.mergeFolderAndFilePath((String)this.colspath, (String[])new String[]{this.connConf.getHost(), db}));
            for (String tb : tbs) {
                List times = ZkClient.getInst().getChildren(IOUtil.mergeFolderAndFilePath((String)this.colspath, (String[])new String[]{this.connConf.getHost(), db, tb}));
                for (String timestr : times) {
                    ListenerConf.ColHis dateObj = (ListenerConf.ColHis)ZkClient.getInst().getDateObj(IOUtil.mergeFolderAndFilePath((String)this.colspath, (String[])new String[]{this.connConf.getHost(), db, tb, timestr}), ListenerConf.ColHis.class);
                    retlist.add(dateObj);
                }
            }
        }
        return retlist;
    }

    public YesOrNo acquireLock() {
        log.info("----------------------\u5f00\u59cb\u83b7\u5f97\u5206\u5e03\u5f0f\u9501-------------------------------------");
        try {
            this.lock = ZkClient.getInst().lockPath(this.lockpath, Long.valueOf(30000L));
        }
        catch (Exception e1) {
            log.error("\u83b7\u53d6\u9501\u5f02\u5e38", (Throwable)e1);
            return YesOrNo.no;
        }
        if (this.lock == null) {
            log.error("\u672a\u83b7\u5f97\u5206\u5e03\u5f0f\u9501");
            return YesOrNo.no;
        }
        return YesOrNo.yes;
    }

    public void releaseLock() {
        try {
            this.lock.release();
        }
        catch (Exception e) {
            log.error("\u91ca\u653e\u9501\u5931\u8d25", (Throwable)e);
        }
    }
}

