/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone.checkpoint;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.apiext.jdbc.JdbcConnection;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.binlog.listener.ISaveCheckPoint;
import net.wicp.tams.common.constant.DbType;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckPointMysql
implements ISaveCheckPoint {
    private static final Logger log = LoggerFactory.getLogger(CheckPointMysql.class);
    private Connection connection = null;
    private Connection connectionLock = null;
    private String url = "";
    private ListenerConf.ConnConf connConf;
    private String lockTableName = "";
    private PreparedStatement pointPrep;
    private PreparedStatement colSaveColsPre;
    private PreparedStatement queryPointPre;
    private PreparedStatement queryColsPre;

    public void init(ListenerConf.ConnConf.Builder connConfBuilder) {
        try {
            String defaultdb;
            Map chkConfig = Conf.getPre((String)"common.binlog.alone.binlog.global.chk.mysql", (boolean)true);
            String host = StringUtil.isNotNull(chkConfig.get("host")) ? (String)chkConfig.get("host") : connConfBuilder.getHost();
            String username = StringUtil.isNotNull(chkConfig.get("username")) ? (String)chkConfig.get("username") : connConfBuilder.getUsername();
            String password = StringUtil.isNotNull(chkConfig.get("password")) ? (String)chkConfig.get("password") : connConfBuilder.getPassword();
            int port = StringUtil.isNotNull(chkConfig.get("port")) ? Integer.parseInt((String)chkConfig.get("port")) : connConfBuilder.getPort();
            String string = defaultdb = StringUtil.isNotNull(chkConfig.get("defaultdb")) ? (String)chkConfig.get("defaultdb") : "tams";
            if (StringUtil.isNull((Object)host) || StringUtil.isNull((Object)username) || StringUtil.isNull((Object)password)) {
                throw new RuntimeException("\u4f7f\u7528mysql\u7684checkpoint\u9700\u8981\u8fde\u63a5\u76f8\u5173\u914d\u7f6e");
            }
            this.url = DbType.mysql.geturl(host, port, defaultdb);
            this.connection = JdbcConnection.getConnectionMyql((String)this.url, (String)username, (String)password);
            Statement stmt = this.connection.createStatement();
            int executeUpdate = stmt.executeUpdate("CREATE TABLE IF NOT EXISTS `position`  (`gtids` varchar(190) NOT NULL,`fileName` varchar(255) NULL,`pos` bigint NULL,`masterServerId` bigint NULL,`time` bigint NULL,`timeStr` varchar(255) NULL,`serverIp` varchar(255) NOT NULL,`clintId` varchar(255) NOT NULL,PRIMARY KEY (`gtids`),INDEX `serverip_clientid_time`(`serverIp`, `clintId`, `time`) USING BTREE)");
            int executeUpdate2 = stmt.executeUpdate("CREATE TABLE IF NOT EXISTS `colhis`  (`db` varchar(190) NOT NULL,`tb` varchar(190) NOT NULL,`time` bigint NOT NULL,`timeStr` varchar(255)  NULL,`serverIp` varchar(255) NOT NULL,`cols` varchar(5000) NOT NULL,`coltypes` varchar(3000) NOT NULL,PRIMARY KEY (`db`,`tb`, `time`))");
            int executeUpdate3 = 0;
            if (StringUtil.isNotNull((Object)connConfBuilder.getGroupId())) {
                this.connectionLock = JdbcConnection.getConnectionMyql((String)this.url, (String)username, (String)password);
                this.lockTableName = String.format("t_lock_%s_%s", connConfBuilder.getGroupId(), connConfBuilder.getHost()).replaceAll("-", "_").replaceAll("\\.", "_");
                this.lockTableName = this.lockTableName.length() > 60 ? this.lockTableName.substring(0, 61) : this.lockTableName;
                executeUpdate3 = stmt.executeUpdate("CREATE TABLE IF NOT EXISTS `" + this.lockTableName + "`  (`id` int NOT NULL,PRIMARY KEY (`id`))");
            }
            stmt.close();
            if (executeUpdate != 0 || executeUpdate2 != 0 || StringUtil.isNotNull((Object)this.lockTableName) && executeUpdate3 != 0) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.jdbc_exec_fail, "\u521b\u5efatable\u5931\u8d25");
            }
            this.connConf = connConfBuilder.build();
            log.info("execute=" + executeUpdate);
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u521d\u59cb\u5316\u5931\u8d25", e);
        }
    }

    public void shutdown() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            log.error("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)e);
        }
    }

    public void savePoint(ListenerConf.Position pos) {
        this.pointPrep = this.checkStmt("replace into position (gtids,filename,pos,masterserverid,time,timeStr,serverIp,clintId) values(?,?,?,?,?,?,?,?)", this.pointPrep);
        try {
            JdbcAssit.setPreParam((PreparedStatement)this.pointPrep, (Object[])new Object[]{pos.getGtids(), pos.getFileName(), pos.getPos(), pos.getMasterServerId(), pos.getTime(), pos.getTimeStr(), pos.getServerIp(), pos.getClintId()});
            this.pointPrep.executeUpdate();
            log.info("\u4fdd\u5b58\u5b9e\u4f8b:{} \u4f4d\u70b9{}\u6210\u529f", (Object)pos.getServerIp(), (Object)pos.getGtids());
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u4f4d\u70b9\u5931\u8d25,\u5b9e\u4f8b:" + pos.getServerIp() + " \u4f4d\u70b9:" + pos.getGtids(), (Throwable)e);
        }
    }

    private PreparedStatement checkStmt(String sql, PreparedStatement stmt) {
        PreparedStatement returnobj = stmt;
        while (true) {
            try {
                if (this.connection == null || this.connection.isClosed()) {
                    if (stmt != null && stmt.isClosed()) {
                        stmt.close();
                    }
                    this.connection = DriverManager.getConnection(this.url, "sa", "");
                }
                if (stmt != null) break;
                returnobj = this.connection.prepareStatement(sql);
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u4e0a\u6216\u521b\u5efastmt\u5931\u8d25", (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
        return returnobj;
    }

    public void saveColName(ListenerConf.ColHis colHis) {
        this.colSaveColsPre = this.checkStmt("replace into colhis (db,tb,time,timeStr,serverIp,cols,coltypes) values(?,?,?,?,?,?,?)", this.colSaveColsPre);
        try {
            String cols = CollectionUtil.listJoin((List)colHis.getColsList(), (String)",");
            String colstype = CollectionUtil.listJoin((List)colHis.getColTypesList(), (String)",");
            JdbcAssit.setPreParam((PreparedStatement)this.colSaveColsPre, (Object[])new Object[]{colHis.getDb(), colHis.getTb(), colHis.getTime(), colHis.getTimeStr(), colHis.getServerIp(), cols, colstype});
            this.colSaveColsPre.executeUpdate();
            log.info("\u4fdd\u5b58\u5b57\u6bb5\u540d\u6210\u529f,db{},tb{},time{}", new Object[]{colHis.getDb(), colHis.getTb(), colHis.getTime()});
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u4f4d\u70b9\u5931\u8d25", (Throwable)e);
        }
    }

    public ListenerConf.Position findPoint(long time) {
        this.queryPointPre = this.checkStmt("select * from position  where serverIp=? and clintId=? and time<=?   order by time desc limit 0,1", this.queryPointPre);
        ListenerConf.Position retojb = null;
        try {
            JdbcAssit.setPreParam((PreparedStatement)this.queryPointPre, (Object[])new Object[]{this.connConf.getHost(), this.connConf.getClientId(), time});
            ResultSet executeQuery = this.queryPointPre.executeQuery();
            if (executeQuery.next()) {
                ListenerConf.Position.Builder builder = ListenerConf.Position.newBuilder();
                builder.setFileName(executeQuery.getString("fileName"));
                builder.setGtids(executeQuery.getString("gtids"));
                builder.setPos(executeQuery.getLong("pos"));
                builder.setMasterServerId(executeQuery.getLong("masterServerId"));
                builder.setTime(executeQuery.getLong("time"));
                builder.setTimeStr(executeQuery.getString("timeStr"));
                builder.setServerIp(executeQuery.getString("serverIp"));
                builder.setClintId(executeQuery.getInt("clintId"));
                retojb = builder.build();
            }
        }
        catch (SQLException e) {
            log.error("\u67e5\u8be2\u4f4d\u70b9\u5931\u8d25", (Throwable)e);
        }
        return retojb;
    }

    public List<ListenerConf.ColHis> findColsList(String db, String tb) {
        this.queryColsPre = this.checkStmt("select * from colhis  where db=? and tb=? and serverIp=? order by time desc", this.queryColsPre);
        ArrayList<ListenerConf.ColHis> retlist = new ArrayList<ListenerConf.ColHis>();
        try {
            JdbcAssit.setPreParam((PreparedStatement)this.queryColsPre, (Object[])new Object[]{db, tb, this.connConf.getHost()});
            ResultSet resultSet = this.queryColsPre.executeQuery();
            while (resultSet.next()) {
                ListenerConf.ColHis.Builder tempBuilder = ListenerConf.ColHis.newBuilder();
                tempBuilder.setDb(db);
                tempBuilder.setTb(tb);
                tempBuilder.setTime(resultSet.getLong("time"));
                tempBuilder.setTimeStr(resultSet.getString("timeStr"));
                tempBuilder.setServerIp(resultSet.getString("serverIp"));
                String[] colsAry = resultSet.getString("cols").split(",");
                tempBuilder.addAllCols(Arrays.asList(colsAry));
                String[] coltypesAry = resultSet.getString("coltypes").split(",");
                tempBuilder.addAllColTypes(Arrays.asList(coltypesAry));
                retlist.add(tempBuilder.build());
            }
            resultSet.close();
        }
        catch (Exception e) {
            log.error("\u67e5colname\u5931\u8d25", (Throwable)e);
        }
        return retlist;
    }

    public List<ListenerConf.ColHis> findColsAll() {
        ArrayList<ListenerConf.ColHis> retlist = new ArrayList<ListenerConf.ColHis>();
        try {
            ResultSet resultSet = JdbcAssit.querySql((Connection)this.connection, (String)("select * from colhis where serverIp='" + this.connConf.getHost() + "' order by time desc"));
            while (resultSet.next()) {
                ListenerConf.ColHis.Builder tempBuilder = ListenerConf.ColHis.newBuilder();
                tempBuilder.setDb(resultSet.getString("db"));
                tempBuilder.setTb(resultSet.getString("tb"));
                tempBuilder.setTime(resultSet.getLong("time"));
                tempBuilder.setTimeStr(resultSet.getString("timeStr"));
                tempBuilder.setServerIp(resultSet.getString("serverIp"));
                String[] colsAry = resultSet.getString("cols").split(",");
                tempBuilder.addAllCols(Arrays.asList(colsAry));
                String[] coltypesAry = resultSet.getString("coltypes").split(",");
                tempBuilder.addAllColTypes(Arrays.asList(coltypesAry));
                retlist.add(tempBuilder.build());
            }
            resultSet.close();
        }
        catch (Exception e) {
            log.error("\u67e5colname all\u5931\u8d25", (Throwable)e);
        }
        return retlist;
    }

    public YesOrNo acquireLock() {
        if (StringUtil.isNull((Object)this.lockTableName)) {
            return YesOrNo.yes;
        }
        while (true) {
            try {
                while (true) {
                    this.connectionLock.setAutoCommit(false);
                    Statement stmt = this.connectionLock.createStatement();
                    stmt.setQueryTimeout(60);
                    stmt.executeUpdate("replace into " + this.lockTableName + " value(1)");
                    ResultSet result = stmt.executeQuery("select * from " + this.lockTableName + " where id=1 for update");
                    if (result != null && result.next() && result.getInt(1) == 1) {
                        return YesOrNo.yes;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                log.info("acquireLock error,No distributed locks were obtained!");
                continue;
            }
            break;
        }
    }

    public void releaseLock() {
        if (StringUtil.isNull((Object)this.lockTableName)) {
            return;
        }
        try {
            this.connectionLock.commit();
        }
        catch (SQLException e) {
            log.error("releaseLock error!", (Throwable)e);
        }
    }
}

