/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.BinlogStart;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.parser.ParseLogOnline;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BusiAssit {
    private static final Logger log = LoggerFactory.getLogger(BusiAssit.class);

    public static void startListenerForConfig() {
        List<ListenerConf.ConnConf.Builder> confs = BusiAssit.ConfigInit();
        for (ListenerConf.ConnConf.Builder conf : confs) {
            BinlogStart.listeningNonBlocking(conf);
        }
        ScheduledExecutorService timerService = Executors.newSingleThreadScheduledExecutor();
        timerService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                List<Thread> startThreadList = ParseLogOnline.startThreadList;
                if (CollectionUtils.isEmpty(startThreadList)) {
                    log.warn("has no listener tasks");
                    return;
                }
                for (Thread startThread : startThreadList) {
                    log.info("the listener:{} isAlive:{}", (Object)startThread.getName(), (Object)startThread.isAlive());
                }
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public static Map<String, Map<String, String>> getConfigMap() {
        Map preGroups = Conf.getPreGroup((String)"common.binlog.alone.binlog.conf.", (String[])new String[]{"common.binlog.alone.binlog.global.conf."});
        return preGroups;
    }

    public static ListenerConf.ConnConf.Builder configMap(String configKey, Map<String, String> map) {
        Validate.notBlank((CharSequence)configKey, (String)"binlog\u76d1\u542c\u914d\u7f6e\u9879configKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)MapUtils.isNotEmpty(map), (String)"binlog\u76d1\u542cmap\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ListenerConf.ConnConf.Builder newBuilder = ListenerConf.ConnConf.newBuilder();
        newBuilder.setConfName(configKey);
        if (StringUtil.isNotNull((Object)map.get("host"))) {
            newBuilder.setHost(StringUtil.trimSpace((String)map.get("host")));
        }
        if (StringUtil.isNotNull((Object)map.get("username"))) {
            newBuilder.setUsername(StringUtil.trimSpace((String)map.get("username")));
        }
        if (StringUtil.isNotNull((Object)map.get("password"))) {
            newBuilder.setPassword(StringUtil.trimSpace((String)map.get("password")));
        }
        if (StringUtil.isNotNull((Object)map.get("listener"))) {
            newBuilder.setListener(StringUtil.trimSpace((String)map.get("listener")));
        }
        if (StringUtil.isNotNull((Object)map.get("port"))) {
            newBuilder.setPort(Integer.parseInt(StringUtil.trimSpace((String)map.get("port"))));
        }
        if (StringUtil.isNotNull((Object)map.get("busier"))) {
            newBuilder.setBusier(StringUtil.trimSpace((String)map.get("busier")));
        }
        if (StringUtil.isNotNull((Object)map.get("filterConf"))) {
            newBuilder.setBusier(StringUtil.trimSpace((String)map.get("filterConf")));
        }
        if (StringUtil.isNotNull((Object)map.get("rule"))) {
            newBuilder.setRule(StringUtil.trimSpace((String)map.get("rule")));
        }
        if (StringUtil.isNotNull((Object)map.get("rds"))) {
            newBuilder.setRds(Boolean.parseBoolean(StringUtil.trimSpace((String)map.get("rds"))));
        }
        if (StringUtil.isNotNull((Object)map.get("clientId"))) {
            newBuilder.setClientId(Integer.parseInt(StringUtil.trimSpace((String)map.get("clientId"))));
        }
        if (StringUtil.isNotNull((Object)map.get("groupId"))) {
            newBuilder.setGroupId(StringUtil.trimSpace((String)map.get("groupId")));
        }
        if (StringUtil.isNotNull((Object)map.get("chk"))) {
            newBuilder.setChk(StringUtil.trimSpace((String)map.get("chk")));
        }
        if (StringUtil.isNotNull((Object)map.get("haType"))) {
            ListenerConf.HaType haType = (ListenerConf.HaType)ListenerConf.HaType.valueOf(ListenerConf.HaType.class, (String)StringUtil.trimSpace((String)map.get("haType")));
            if (haType == null) {
                haType = ListenerConf.HaType.cur;
            }
            newBuilder.setHaType(haType);
        }
        if (StringUtil.isNotNull((Object)map.get("pos.gtids"))) {
            ListenerConf.Position.Builder posBuilder = ListenerConf.Position.newBuilder().setGtids(StringUtil.trimSpace((String)map.get("pos.gtids")));
            newBuilder.setPos(posBuilder);
        }
        return newBuilder;
    }

    public static ListenerConf.ConnConf.Builder configMap(String configKey) {
        Map map = Conf.getPre((String)"common.binlog.alone.binlog.global.conf.", (String)("common.binlog.alone.binlog.conf." + configKey), (boolean)true);
        return BusiAssit.configMap(configKey, map);
    }

    public static List<ListenerConf.ConnConf.Builder> ConfigInit() {
        Map<String, Map<String, String>> configMaps = BusiAssit.getConfigMap();
        ArrayList<ListenerConf.ConnConf.Builder> confs = new ArrayList<ListenerConf.ConnConf.Builder>();
        for (String preGroup : configMaps.keySet()) {
            Map<String, String> map = configMaps.get(preGroup);
            ListenerConf.ConnConf.Builder configMap = BusiAssit.configMap(preGroup, map);
            confs.add(configMap);
        }
        return confs;
    }

    public static String getColHiskey(String db, String tb) {
        String key = String.format("%s|%s", db, tb).toLowerCase();
        return key;
    }
}

