package net.wicp.tams.common.binlog.plugin.logger;

import java.util.Map;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf.ColHis;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.listener.AbsBinlogListener;

/***
 * 日志,也可以转为纯内存，不存文件，用于做测试
 * 
 * @author andy.zhou
 *
 */
@Slf4j
public class ListenerLogger extends AbsBinlogListener {

	@Override
	public void doBusiTrue(Rule rule, DuckulaEvent duckulaEvent, boolean isSplit) {
		log.info("opttype:{},db:{},tb:{}", duckulaEvent.getOptType().name(), duckulaEvent.getDb(),
				duckulaEvent.getTb());
		for (int i = 0; i < duckulaEvent.getItemsCount(); i++) {
			Map<String, String> values = DuckulaAssit.getValueMap(duckulaEvent, i);
			log.info("the value:{}", values);
		}
	}

	@Override
	public Result doAlterTableCallBack(Rule rule, ColHis colHis, String altersql,String[] addColNames,String updateColName,String[] deleteColNames) {
		return Result.getSuc();
	}

	@Override
	public void doInit(Rule rule, int index) {
		log.info("init rule:{}", index);
	}

}
