package net.wicp.tams.common.binlog.plugin.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcData;
import net.wicp.tams.common.apiext.jdbc.JdbcDatas;
import net.wicp.tams.common.apiext.jdbc.JdbcDatas.Builder;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf.ColHis;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.binlog.listener.AbsBinlogListener;
import net.wicp.tams.common.constant.JvmStatus;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.jdbc.DruidAssit;

@Slf4j
public class ListenerJdbc extends AbsBinlogListener {
	@Override
	public void doInit(Rule rule, int index) {
		String dbinstanceid = rule.getItems().get(RuleItem.dbinstanceid);
		Validate.isTrue(StringUtil.isNotNull(dbinstanceid), "每组规则都需要配置dbinstanceid。");
		Validate.isTrue(StringUtil.isNotNull(rule.getItems().get(RuleItem.dbtb)), "每组规则都需要配置dbtb。");
		// 添加配置
		Properties newprops = Conf.replacePre(String.format("common.binlog.alone.plugin.jdbc.%s.", dbinstanceid),
				"common.jdbc.datasource." + dbinstanceid);
		Conf.overProp(newprops);
		// String[] dbtb = rule.getItems().get(RuleItem.dbtb).split("\\.");
		// 初始化时 比较字段,并同步
		/*
		 * Connection connection = DruidAssit.getConnection(dbinstanceid);
		 * List<Triple<String, String, String>> colList =
		 * MySqlAssit.getColsNew(connection, dbtb[0], dbtb[1], connConf.getRds() ?
		 * YesOrNo.yes : YesOrNo.no); ColHis retobj =
		 * PluginAssit.convertCosHis(connConf.getHost(), dbtb[0], dbtb[1], -1l,
		 * colList); doAlterTableCallBack(rule, retobj);
		 */
	}

	@Override
	public Result doAlterTableCallBack(Rule rule, ColHis colHis, String altersql,String[] addColNames,String updateColName,String[] deleteColNames) {
		Connection connection = DruidAssit.getConnection(rule.getItems().get(RuleItem.dbinstanceid));
		String[] dbtb = rule.getItems().get(RuleItem.dbtb).split("\\.");
		String[][] cols = MySqlAssit.getCols(connection, dbtb[0], dbtb[1], YesOrNo.no);
		// 只处理新增列
		List<Pair<String, String>> addColAndSqlType = new ArrayList<Pair<String, String>>();
		for (int i = 0; i < colHis.getColsCount(); i++) {
			if (!ArrayUtils.contains(cols[0], colHis.getCols(i))) {
				addColAndSqlType.add(Pair.of(colHis.getCols(i), colHis.getColTypes2(i)));
			}
		}
		if (CollectionUtils.isEmpty(addColAndSqlType)) {
			return Result.getSuc();
		}
		StringBuffer sqlbuf = new StringBuffer(String.format("ALTER TABLE `%s`.`%s` ", dbtb[0], dbtb[1]));
		String sql = null;
		if (StringUtil.isNull(altersql)) {
			for (Pair<String, String> pair : addColAndSqlType) {
				sqlbuf.append(String.format("ADD COLUMN `%s` %s NULL,", pair.getLeft(), pair.getRight()));
			}
			sql = sqlbuf.substring(0, sqlbuf.length() - 1);
		} else {
			String toLowerSql = altersql.toLowerCase();// add
			int firstadd = toLowerSql.indexOf("add ");
			sqlbuf.append(toLowerSql.substring(firstadd));
			sql = sqlbuf.toString();
		}
		log.info("修改表结构：[{}]", sql);

		try {
			connection.createStatement().execute(sql);
			connection.close();
		} catch (SQLException e) {
			log.error("你没有权限修改表结构，请手动创建:", e);
			LoggerUtil.exit(JvmStatus.s15);// 不需要重做，有可能是没有权限做此操作
			return Result.getError("你没有权限修改表结构，请手动创建:" + e.getMessage());
		}
		return Result.getSuc();
	}

	@Override
	public void doBusiTrue(Rule rule, DuckulaEvent duckulaEvent, boolean isSplit) {
		Connection connection = DruidAssit.getConnection(rule.getItems().get(RuleItem.dbinstanceid));
		Builder builder = JdbcDatas.newBuilder();
		String[] dbtb = rule.getItems().get(RuleItem.dbtb).split("\\.");
		builder.setDb(dbtb[0]);
		builder.setTb(dbtb[1]);
		builder.addAllCols(duckulaEvent.getColsList());
		builder.setOptTypeValue(duckulaEvent.getOptTypeValue());
		builder.addKeys(duckulaEvent.getCols(0));// 暂时只支持一个主键
		Map<String, String> typemap = new HashMap<String, String>();
		for (int i = 0; i < duckulaEvent.getColsCount(); i++) {
			typemap.put(duckulaEvent.getCols(i), duckulaEvent.getColsType(i).name());
		}
		builder.putAllType(typemap);
		List<JdbcData> datas = new ArrayList<JdbcData>();
		for (int i = 0; i < duckulaEvent.getItemsCount(); i++) {
			net.wicp.tams.common.apiext.jdbc.JdbcData.Builder dataBuilder = JdbcData.newBuilder();
			dataBuilder.putAllValue(DuckulaAssit.getValueMap(duckulaEvent, i));
			datas.add(dataBuilder.build());
		}
		builder.addAllDatas(datas);
		Result dataUpset = MySqlAssit.dataChange(connection, builder.build());
		if (!dataUpset.isSuc()) {
			throw new ProjectExceptionRuntime(ExceptAll.jdbc_exec_fail, "保存数据失败");
		}
		try {
			connection.close();
		} catch (SQLException e) {
		}
	}

}
