package net.wicp.tams.common.binlog.plugin.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.lang3.Validate;

import com.alibaba.fastjson.JSONObject;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.jdbc.JdbcData;
import net.wicp.tams.common.apiext.jdbc.JdbcDatas;
import net.wicp.tams.common.apiext.jdbc.JdbcDatas.Builder;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.apiext.jdbc.OptType;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiSender;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.jdbc.DruidAssit;

@Slf4j
public class DumperJdbc implements IBusiSender<DumpEvent> {

	private String dbinstanceid;
	private String db;
	private String tb;

	@Override
	public void init(Dump dump) {
		Validate.notEmpty(dump.getBusiPluginConfig(), "需要扩展属性");
		Validate.notBlank(dump.getBusiPluginConfig().getString(RuleItem.dbinstanceid.name()),
				"需要扩展属性，它是一个json且包含有 dbinstanceid值。");
		Validate.notBlank(dump.getBusiPluginConfig().getString(RuleItem.dbtb.name()), "需要扩展属性，它是一个json且包含有 dbtb值。");
		this.dbinstanceid = dump.getBusiPluginConfig().getString(RuleItem.dbinstanceid.name());
		String[] dbtb = dump.getBusiPluginConfig().getString(RuleItem.dbtb.name()).split("\\.");
		this.db = dbtb[0];
		this.tb = dbtb[1];
		// 添加配置
		Properties newprops = Conf.replacePre(String.format("common.binlog.alone.plugin.jdbc.%s.", dbinstanceid),
				"common.jdbc.datasource." + dbinstanceid);
		Conf.overProp(newprops);
	}

	@Override
	public void doSend(DumpEvent dumpEvent) {
		Builder newBuilder = JdbcDatas.newBuilder();
		newBuilder.addAllCols(Arrays.asList(dumpEvent.getDump().getNeedCols()));
		newBuilder.setDb(this.db);
		newBuilder.setTb(this.tb);
		newBuilder.setOptType(OptType.update);
		newBuilder.addAllKeys(Arrays.asList(dumpEvent.getDump().getPrimarys()));
		for (int i = 0; i < dumpEvent.getDump().getNeedCols().length; i++) {
			newBuilder.putType(dumpEvent.getDump().getNeedCols()[i], dumpEvent.getDump().getNeedColTypes()[i].name());
		}
		for (Map<String, String> data : dumpEvent.getDatas()) {
			net.wicp.tams.common.apiext.jdbc.JdbcData.Builder jdbcDataBuild = JdbcData.newBuilder();
			jdbcDataBuild.putAllValue(data);
			newBuilder.addDatas(jdbcDataBuild);
		}
		Connection conn = DruidAssit.getConnection(dbinstanceid);
		try {
			Result temp = MySqlAssit.dataChange(conn, newBuilder.build());
			if (!temp.isSuc()) {
				log.error("同步错误,原因：{}", temp.getMessage());
				throw new ProjectExceptionRuntime(ExceptAll.jdbc_exec_fail);
			}
		} finally {
			try {
				conn.close();
			} catch (SQLException e) {
				log.error("close the connection error", e);
			}
		}

	}

	@Override
	public void initParams(JSONObject params) {
	}

}
