package net.wicp.tams.common.binlog.dump.handlerConsumer;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

import org.apache.commons.collections.CollectionUtils;

import com.lmax.disruptor.WorkHandler;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.apiext.TimeAssist;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiSender;
import net.wicp.tams.common.binlog.dump.DumpGroup;
import net.wicp.tams.common.binlog.dump.MainDump;
import net.wicp.tams.common.constant.JvmStatus;

@Slf4j
public class SendHander implements WorkHandler<DumpEvent> {
	private final Map<String, IBusiSender<DumpEvent>> sendmap = new HashMap<String, IBusiSender<DumpEvent>>();
	private final Map<String, Dump> dumpmap = new HashMap<String, Dump>();
	private final String formatestr = "%s.%s";
	private  static CountDownLatch countDownLatch;
	
	
	public static void setCountDownLatch(CountDownLatch countDownLatch) {
		SendHander.countDownLatch=countDownLatch;
	}
	
	public SendHander(Dump[] dumps) {
		for (Dump dump : dumps) {
			sendmap.put(String.format(formatestr, dump.getDbDemo(), dump.getTbDemo()), dump.getBusiSender());
			dumpmap.put(String.format(formatestr, dump.getDbDemo(), dump.getTbDemo()), dump);
		}
	}

	@Override
	public void onEvent(DumpEvent event) throws Exception {
		Thread.currentThread().setName("SendHanderThread");
		String key = String.format(formatestr, event.getDump().getDbDemo(), event.getDump().getTbDemo());
		IBusiSender<DumpEvent> iBusiSend = this.sendmap.get(key);
		DumpGroup dumpGroup = MainDump.metricsMap.get(this.dumpmap.get(key).getId());
		if (iBusiSend == null || event == null || CollectionUtils.isEmpty(event.getDatas())) {
			dumpGroup.counter_send_num.inc(event.getDatas().size());
			dumpGroup.counter_send_event.inc();
			this.dumpmap.get(key).setLastId(event.getEndId());
			isOver();
			return;
		}

		while (true) {
			try {
				iBusiSend.doSend(event);
				dumpGroup.counter_send_num.inc(event.getDatas().size());
				dumpGroup.counter_send_event.inc();
				this.dumpmap.get(key).setLastId(event.getEndId());
				isOver();
				break;
			} catch (Throwable e) {
				boolean reDoWait = TimeAssist.reDoWait("tams-send", 7);
				if (reDoWait) {// 达到最大值就出
					dumpGroup.counter_send_error.inc();// 发送失败
					log.error("重试7次都不能拿到链接，退出");
					LoggerUtil.exit(JvmStatus.s15);
				} else {
					log.error("不能发送数据，重试", e);
					continue;
				}
			}
		}

	}

	public void isOver() {
		if(MainDump.ringBuffer.getCursor() - MainDump.ringBuffer.getMinimumGatingSequence()>0) {
			return;
		}
		boolean isover = true;
		for (Publisher publisher : MainDump.publishers) {
			if (!publisher.isIsover()) {
				isover = false;
				break;
			}
		}
		if (isover) {
			log.info("========dump sucess!========");
			try {
				MainDump.shutdown();
				log.info("shutdown executor sucess");
			} finally {
				Conf.overProp("common.binlog.alone.dump.global.isOver", "true");// 设置标识
				if (Conf.getBoolean("common.binlog.alone.dump.global.overExit")) {// 成功后退出JVM
					LoggerUtil.exit(JvmStatus.s15);
				}
				if(countDownLatch!=null) {
					countDownLatch.countDown();
				}
			}
		}
	}
}
