package net.wicp.tams.common.binlog.dump.handlerConsumer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import com.lmax.disruptor.RingBuffer;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.TimeAssist;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.binlog.alone.Config;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.dump.MainDump;
import net.wicp.tams.common.constant.JvmStatus;
import net.wicp.tams.common.jdbc.DruidAssit;

@Slf4j
public class Publisher implements Runnable {
	private final RingBuffer<DumpEvent> ringBuffer;

	private Connection connection;
	private PreparedStatement stmt;
	private int numDuan;// 一段数量 默认500
	private final int numBatch = Integer.parseInt(Conf.get("common.binlog.alone.dump.global.batchNum"));// 一次大批量数,默认20000
	private final long maxDuanNo;
	private final long maxBatchNo;
	private final String temp;
	private boolean isover = false;
	private final String startId;
	private final long numLastBatch;
	private final Dump dump;

	public Publisher(RingBuffer<DumpEvent> ringBuffer, Dump dump) {
		this.dump = dump;
		this.ringBuffer = ringBuffer;
		numDuan = dump.getNumDuan() == 0 ? 500 : dump.getNumDuan();
		Long recordNum = dump.getNumDump();
		if (recordNum != null && recordNum >= 0) {
			maxBatchNo = recordNum / numBatch + (recordNum % numBatch == 0 ? 0 : 1);
			long lastBatchRecords = recordNum - (maxBatchNo - 1) * numBatch;
			maxDuanNo = (maxBatchNo - 1) * (numBatch / numDuan + (numBatch % numDuan == 0 ? 0 : 1))
					+ lastBatchRecords / numDuan + (lastBatchRecords % numDuan == 0 ? 0 : 1);
			numLastBatch = recordNum - (maxBatchNo - 1) * numBatch;
		} else {
			numLastBatch = numBatch;
			maxDuanNo = Long.MAX_VALUE;
			maxBatchNo = Long.MAX_VALUE;
		}
		this.startId = dump.getStartId();
		String primaryName = dump.getPrimarys()[0];
		this.temp = String.format("select %s %s and %s>=?  order by %s limit ?,?", primaryName, dump.packFromstr(),
				primaryName, primaryName);
		log.info("--------maxDuanNo={},maxBatchNo={}-------", maxDuanNo == Long.MAX_VALUE ? -1 : maxDuanNo,
				maxBatchNo == Long.MAX_VALUE ? -1 : maxBatchNo);
	}

	private int batchNo = 0;
	private int duanNo = 0;
	private long timeBegin = 0;

	@Override
	public void run() {
		Thread.currentThread().setName("PublisherThread");
		String lastId = StringUtil.hasNull(this.startId, "");
		boolean isFirstBatch = true;
		boolean isLastBatch = false;
		this.timeBegin = System.currentTimeMillis();
		while (true) {
			try {
				ResultSet rsDuan = null;
				while (true) {
					try {
						if (this.connection == null || connection.isClosed()) {
							// 先关闭旧的stmt;
							if (this.stmt != null && this.stmt.isClosed()) {
								this.stmt.close();
							}
							this.connection = DruidAssit.getConnection(Config.globleDatasourceName);
							this.stmt = connection.prepareStatement(this.temp);
							this.stmt.setFetchSize(numBatch);
						}
						JdbcAssit.setPreParam(stmt, lastId, isFirstBatch ? 0 : 1,
								(isLastBatch && numLastBatch > 0) ? numLastBatch : numBatch);
						rsDuan = stmt.executeQuery();
						if (rsDuan != null) {
							break;
						}
					} catch (Throwable e) {					
						boolean reDoWait = TimeAssist.reDoWait("tams-dump", 7);
						if (reDoWait) {// 达到最大值就出出
							log.error("重试7次都不能拿到链接，退出");
							LoggerUtil.exit(JvmStatus.s15);
						} else {
							log.error("不能查询数据，重试",e);
							continue;
						}
					}
				}

				int i = 0;
				String start = null;
				String end = null;
				if (!rsDuan.next()) {
					break;
				} else {
					start = rsDuan.getString(1);
					end = rsDuan.getString(1);
					i++;
				}
				while (rsDuan.next() && duanNo < maxDuanNo) {
					if (i == 0) {
						start = rsDuan.getString(1);
						end = rsDuan.getString(1);
						i++;
					} else if (i == numDuan - 1) {
						end = rsDuan.getString(1);
						pushData(start, end);
						lastId = end;
						duanNo++;
						i = 0;
						start = null;
						end = null;
					} else {
						end = rsDuan.getString(1);
						i++;
					}
				}
				// 最后一批数据
				if (start != null && end != null && duanNo < maxDuanNo) {
					pushData(start, end);
					duanNo++;
					lastId = end;
				}
				batchNo++;
				rsDuan.close();
			} catch (Exception e) {
				log.error("生产者执行失败", e);
				LoggerUtil.exit(JvmStatus.s15);
			}
			if (duanNo >= maxDuanNo) {// 需要有=号，否则会多做一次查询
				break;
			}
			isLastBatch = (batchNo == maxBatchNo - 1) ? true : false;
			isFirstBatch = false;
		}
		isover = true;
		try {
			stmt.close();
			connection.close();
		} catch (Exception e) {
			log.error("回收资源失败", e);
		}

	}

	private void pushData(String start, String end) {
		long sequence = ringBuffer.next();
		DumpEvent event = ringBuffer.get(sequence);
		event.setBeginId(start);
		event.setEndId(end);
		event.setDump(dump);
		// event.setCols(this.dump.getNeedCols());
		// event.setColsType(this.dump.getNeedColTypes());
		// event.setDb(this.dump.getDb());
		// event.setTb(this.dump.getTb());
		// System.out.println(start + " " + end);
		ringBuffer.publish(sequence);
		// System.out.println("-------min=" + ringBuffer.getMinimumGatingSequence() + "
		// size="
		// + (ringBuffer.getCursor() - ringBuffer.getMinimumGatingSequence()) + "
		// Cursor="
		// + ringBuffer.getCursor() + " batchNo=" + batchNo);
	}

	public int getBatchNo() {
		return batchNo;
	}

	public int getDuanNo() {
		return duanNo;
	}

	public boolean isIsover() {
		return isover &&  MainDump.metricsMap.get(this.dump.getId()).counter_send_event.getCount() == this.getDuanNo();
	}

	public long getTimeBegin() {
		return timeBegin;
	}

	public Dump getDump() {
		return dump;
	}
}
