package net.wicp.tams.common.binlog.dump.handlerConsumer;

import java.util.HashMap;
import java.util.Map;

import javax.sql.DataSource;

import com.lmax.disruptor.WorkHandler;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.binlog.alone.Config;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleFilter;
import net.wicp.tams.common.binlog.alone.constant.FilterPattern;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiFilter;
import net.wicp.tams.common.constant.JvmStatus;
import net.wicp.tams.common.jdbc.DruidAssit;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;

@Slf4j
public class BusiHander implements WorkHandler<DumpEvent> {

	private final Map<String, IBusiFilter<DumpEvent>> filtermap = new HashMap<String, IBusiFilter<DumpEvent>>();
	private final String formatestr = "%s.%s";

	public BusiHander(Dump[] dumps) {
		for (Dump dump : dumps) {
			filtermap.put(String.format(formatestr, dump.getDbDemo(), dump.getTbDemo()), dump.getBusiFilter());
		}
	}

	@Override
	public void onEvent(final DumpEvent event) throws Exception {
		Thread.currentThread().setName("BusiHanderThread");
		// 过滤处理
		for (RuleFilter filterRulePo : event.getDump().getRule().getFilterRules()) {
			if (filterRulePo.getFilterPattern() == FilterPattern.sql) {// 初始化连接池
				DataSource dataSource = DruidAssit.getDataSource(Config.globleDatasourceName);
				PerthreadManager.getInstance().createValue(Config.CurThreadDatasourceName, DataSource.class)
						.set(dataSource);// 过滤器中会使用它
			}
			filterRulePo.getFilterPattern().getFilter().doFilter(event, event.getDump().getRule(), filterRulePo);
			if (event.getDatas().size() == 0) {
				log.info("---------------------过滤后没有处理的数据-----------------------------");
				break;
			}
		}
		if (event.getDatas().size() == 0) {
			return;
		}
		// 处理业务
		IBusiFilter<DumpEvent> iBusiFilter = this.filtermap
				.get(String.format(formatestr, event.getDump().getDbDemo(), event.getDump().getTbDemo()));
		if (iBusiFilter == null) {
			return;
		}
		try {
			iBusiFilter.doBusi(event);
		} catch (Throwable e) {
			log.error("业务处理失败", e);// TODO
			LoggerUtil.exit(JvmStatus.s15);
		}
	}
}
