package net.wicp.tams.common.binlog.dump;

import static com.lmax.disruptor.RingBuffer.createMultiProducer;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;

import com.alibaba.fastjson.JSONObject;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.IgnoreExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WorkProcessor;
import com.lmax.disruptor.util.DaemonThreadFactory;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.binlog.Tools;
import net.wicp.tams.common.binlog.alone.Config;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleManager;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiFilter;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiSender;
import net.wicp.tams.common.binlog.dump.handlerConsumer.BaseDataHander;
import net.wicp.tams.common.binlog.dump.handlerConsumer.BusiHander;
import net.wicp.tams.common.binlog.dump.handlerConsumer.Publisher;
import net.wicp.tams.common.binlog.dump.handlerConsumer.SendHander;
import net.wicp.tams.common.binlog.dump.jmx.DumpControl;
import net.wicp.tams.common.constant.DateFormatCase;
import net.wicp.tams.common.constant.JvmStatus;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.jdbc.DruidAssit;

/***
 * 消费模式
 * 
 * @author 偏锋书生
 *
 *         2018年5月27日
 */
@Slf4j
public class MainDump {
	private static final int BUFFER_SIZE = 8;//节省内存，少放点128 * 1; // 1024 3G以上 256 2.8G 128 2G

	public static final String chkDatasourceName = "_chk";

	// private final ExecutorService executor;// = Executors.newFixedThreadPool(8,
	// DaemonThreadFactory.INSTANCE);

	private static final EventFactory<DumpEvent> EVENT_FACTORY = new EventFactory<DumpEvent>() {
		public DumpEvent newInstance() {
			return new DumpEvent();
		}
	};

	// executorService.shutdown();
	// workerPool.drainAndHalt();
	public static final RingBuffer<DumpEvent> ringBuffer = createMultiProducer(EVENT_FACTORY, BUFFER_SIZE,
			new BlockingWaitStrategy());

	Dump[] dumps = null;

	RuleManager ruleManager = null;

	public void dump() throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
		dump(null);
	}

	private boolean needConf = false;//

	public static Map<String, DumpGroup> metricsMap = new HashMap<String, DumpGroup>();

	public void dump(JSONObject params)
			throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
		// dump初禁用了
		if (!Conf.getBoolean("common.binlog.alone.dump.global.enable")) {
			return;
		}
		ClassLoader classloadertrue = Conf.pluginClassLoader("common.binlog.alone.dump.global.busiPluginDir");
		Thread.currentThread().setName("Dump-main");
		Map<String, Map<String, String>> dumpConfs = Conf.getPreGroup("common.binlog.alone.dump.ori");
		if (MapUtils.isEmpty(dumpConfs)) {
			System.err.println("----未配置dump任务，不能启动task----");
			log.error("----未配置dump任务，不能启动task----");
			return;
		}

		// dumps = new Dump[dumpConfs.size()];
		List<Dump> doList = new ArrayList<Dump>();
		Properties newprops = Conf.replacePre("common.binlog.alone.dump.global.pool",
				"common.jdbc.datasource." + Config.globleDatasourceName);
		Conf.overProp(newprops);
		Connection connection = DruidAssit.getConnection(Config.globleDatasourceName);
		int i = 0;
		Map<String, String> defaultOriConf = Conf.getPre("common.binlog.alone.dump.global.ori", true);
		for (String dumpIdTemp : dumpConfs.keySet()) {
			Map<String, String> mergMap = new HashMap<String, String>();
			mergMap.putAll(defaultOriConf);
			mergMap.putAll(dumpConfs.get(dumpIdTemp));
			dumpConfs.put(dumpIdTemp, mergMap);
			String ruleStr = mergMap.get("rule");
			if (StringUtil.isNull(ruleStr)) {
				log.error("此dump没有规则rule配置：{}", dumpIdTemp);
				continue;
			}
			this.ruleManager = new RuleManager(ruleStr);
			for (int j = 0; j < ruleManager.getRules().size(); j++) {
				Rule rule = ruleManager.getRules().get(j);
				String dumpId = String.format("%s-%s", dumpIdTemp, j);
				String dbPattern = rule.getDbPattern();
				String tbPattern = rule.getTbPattern();
				if (StringUtil.isNull(dbPattern) || StringUtil.isNull(tbPattern)) {
					log.error("the dumpId:{} need db and tb.", dumpId);
					continue;
				}
				Dump.DumpBuilder dumpBuilder = Dump.builder().id(dumpId);
				dumpBuilder.rule(rule);
				dumpBuilder.dbPattern(dbPattern).dbOri(rule.getDbOri()).dbDemo(rule.getDbOri());
				dumpBuilder.tbPattern(tbPattern).tbOri(rule.getTbOri()).tbDemo(rule.getTbOri());
				dumpBuilder.numDuan(Integer.parseInt(mergMap.get("numDuan")));// numDuan
				String[] primarys = MySqlAssit.getPrimary(connection, rule.getDbOri(), rule.getTbOri());// TODO 处理哪个原表
				dumpBuilder.primarys(primarys);
				if (rule.getItems().containsKey(RuleItem.primarysLogic)) {// 如果配置逻辑主键
					dumpBuilder.primarysLogic(rule.getItems().get(RuleItem.primarysLogic).split(","));
				}
				if (rule.getItems().containsKey(RuleItem.wheresql)) {
					// TODO 暂时使用|，'在页面上不能转换
					String wheresql = StringUtil.hasNull(rule.getItems().get(RuleItem.wheresql));
					wheresql = wheresql.replace("|", "'");
					dumpBuilder.wheresql(wheresql);
				}
				dumpBuilder.startId(StringUtil.hasNull(rule.getItems().get(RuleItem.startId)));
				dumpBuilder.numDump(!rule.containsItem(RuleItem.numDump) ? null
						: Long.parseLong(rule.getItems().get(RuleItem.numDump)));
				// 插件使用的设置扩展属性
				dumpBuilder.busiPluginConfig(rule.buildRuleItem());
				// 列过滤
				String[][] cols = MySqlAssit.getCols(connection, rule.getDbOri(), rule.getTbOri(), YesOrNo.yes);// TODO
																												// YesOrNo.yes需要参数化
				if (StringUtil.isNull(rule.getItems().get(RuleItem.needCols))) {
					dumpBuilder.needCols(cols[0]);
					dumpBuilder.needColTypes(Dump.convertColumnType(cols[1]));
				} else {
					String[] configCols = rule.getItems().get(RuleItem.needCols).split(",");
					String[] retEles = CollectionUtil.arrayAnd(String[].class, cols[0], configCols);// cols[0]与configCols不能调换顺序
					retEles = CollectionUtil.arrayMerge(String[].class, retEles, primarys);// 加主键
					String[] retTypes = new String[retEles.length];
					for (int k = 0; k < retEles.length; k++) {
						int index = ArrayUtils.indexOf(cols[0], retEles[k]);
						retTypes[k] = cols[1][index];
					}
					dumpBuilder.needCols(retEles);
					dumpBuilder.needColTypes(Dump.convertColumnType(retTypes));
				}
				if (StringUtil.isNotNull(mergMap.get("busiFilter"))) {
					@SuppressWarnings("unchecked")
					IBusiFilter<DumpEvent> newInstance = (IBusiFilter<DumpEvent>) Class
							.forName(mergMap.get("busiFilter")).newInstance();
					dumpBuilder.busiFilter(newInstance);
				}
				metricsMap.put(dumpId, new DumpGroup(dumpId));
				// 业务发送用
				if (StringUtil.isNotNull(mergMap.get("busiSender"))) {
					String busiSender = StringUtil.trimSpace(mergMap.get("busiSender"));
					try {// 偿试使用内置的枚举
						BusiSenderEnum busiSenderEnum = BusiSenderEnum.valueOf(busiSender);
						if (busiSenderEnum != null) {
							busiSender = busiSenderEnum.getClassName();
						}
					} catch (Exception e) {
					}
					@SuppressWarnings("unchecked")
					IBusiSender<DumpEvent> newInstance = (IBusiSender<DumpEvent>) classloadertrue.loadClass(busiSender)
							.newInstance();
					dumpBuilder.busiSender(newInstance);
					Dump dump = dumpBuilder.build();
					newInstance.init(dump);
					newInstance.initParams(params);
					doList.add(dump);
				} else {
					doList.add(dumpBuilder.build());
				}
				log.info("========the dumpId index:{}, id:{} ======", i++, dumpId);
			}

		}
		if (CollectionUtils.isEmpty(doList)) {
			log.error("没有合适的dump。 需要检查配置.");
			LoggerUtil.exit(JvmStatus.s15);
			return;
		}
		dumps = doList.toArray(new Dump[doList.size()]);
		log.info("----------------------创建last的保存表-------------------------------------");
		if (StringUtil.isNotNull(Conf.get("common.binlog.alone.binlog.global.chk.mysql.host"))) {
			Properties configprops = Conf.replacePre("common.binlog.alone.binlog.global.chk.mysql",
					"common.jdbc.datasource." + chkDatasourceName);
			Conf.overProp(configprops);
			Connection connectionChk = DruidAssit.getConnection(chkDatasourceName);
			Statement stmt = connectionChk.createStatement();
			int executeUpdate = stmt.executeUpdate(
					"CREATE TABLE IF NOT EXISTS `dump_lastid`  (`id` int(11) NOT NULL AUTO_INCREMENT,`dump_id` varchar(255)  NOT NULL,`db` varchar(255)  NOT NULL,`tb` varchar(255)  NOT NULL,`time` datetime(0) NOT NULL,`lastId` varchar(254)  NOT NULL,`speed` double NOT NULL, PRIMARY KEY (`id`))");
			stmt.close();
			connectionChk.close();
			if (executeUpdate != 0) {
				throw new ProjectExceptionRuntime(ExceptAll.jdbc_exec_fail, "创建table失败");
			}
			needConf = true;
		}

		log.info("----------------------启动jmx-------------------------------------");
		try {
			initMbean();// 启动jxmx
		} catch (Exception e) {
			log.error("启动jmx错误", e);
			LoggerUtil.exit(JvmStatus.s15);
		}
		log.info("----------------------配置metrix-------------------------------------");
		// System.setProperty(TsLogger.ENV_FILE_NAME, "dump_" + dumpId);
		// System.setProperty(TsLogger.ENV_FILE_ROOT, String.format("%s/logs/metrics",
		// System.getenv("DUCKULA_DATA")));
		log.info("----------------------启动Disruptor-------------------------------------");
		try {
			disruptorRun();
		} catch (Exception e) {
			log.error("dump失败,将关机，原因：", e);
			LoggerUtil.exit(JvmStatus.s15);
		}
		addTimer();
		Tools.printAscill();
	}

	SequenceBarrier baseBarrier;
	SequenceBarrier busiBarrier;

	public static Publisher[] publishers;
    private SendHander[] sendHanders;
	private static ExecutorService executor;

	private void disruptorRun() throws SQLException {
		// 如果保证顺序需要单线程
		publishers = new Publisher[dumps.length];
		for (int i = 0; i < publishers.length; i++) {
			publishers[i] = new Publisher(ringBuffer, dumps[i]);
		}
		///////////////////////////////// 取基础数据////////////////////////////////////
		Sequence workSequence = new Sequence(-1);
		SequenceBarrier sequenceBarrier = ringBuffer.newBarrier();
		int baseDataNum = Conf.getInt("common.binlog.alone.dump.thread.baseDataNum");
		BaseDataHander[] baseDataHanders = new BaseDataHander[baseDataNum];
		for (int i = 0; i < baseDataHanders.length; i++) {
			baseDataHanders[i] = new BaseDataHander(dumps);
		}
		@SuppressWarnings("unchecked")
		WorkProcessor<DumpEvent>[] baseProcessors = new WorkProcessor[baseDataNum];
		for (int i = 0; i < baseProcessors.length; i++) {
			baseProcessors[i] = new WorkProcessor<DumpEvent>(ringBuffer, sequenceBarrier, baseDataHanders[i],
					new IgnoreExceptionHandler(), workSequence);
		}
		///////////////////////////////////////// 业务处理///////////////////////////////////////////////////////////////////////////////
		baseBarrier = ringBuffer.newBarrier(getSeqAry(baseProcessors));
		Sequence busiSequence = new Sequence(-1);
		int busiNum = Conf.getInt("common.binlog.alone.dump.thread.busiNum");
		BusiHander[] busiHanders = new BusiHander[busiNum];
		for (int i = 0; i < busiHanders.length; i++) {
			busiHanders[i] = new BusiHander(dumps);
		}
		@SuppressWarnings("unchecked")
		WorkProcessor<DumpEvent>[] busiProcessors = new WorkProcessor[busiNum];
		for (int i = 0; i < busiProcessors.length; i++) {
			busiProcessors[i] = new WorkProcessor<DumpEvent>(ringBuffer, baseBarrier, busiHanders[i],
					new IgnoreExceptionHandler(), busiSequence);
		}

		///////////////////////////////////////// 发送处理///////////////////////////////////////////////////////////////////////////////
		busiBarrier = ringBuffer.newBarrier(getSeqAry(busiProcessors));
		Sequence sendSequence = new Sequence(-1);
		// 不需要发送只要一个线程就OK了
		int sendNum = Conf.getInt("common.binlog.alone.dump.thread.sendNum");
		sendHanders = new SendHander[sendNum];
		executor = Executors.newFixedThreadPool(publishers.length + baseDataNum + busiNum + sendNum,
				DaemonThreadFactory.INSTANCE);
		for (int i = 0; i < sendHanders.length; i++) {
			sendHanders[i] = new SendHander(dumps);
		}
		@SuppressWarnings("unchecked")
		WorkProcessor<DumpEvent>[] sendProcessors = new WorkProcessor[sendNum];
		for (int i = 0; i < sendProcessors.length; i++) {
			sendProcessors[i] = new WorkProcessor<DumpEvent>(ringBuffer, busiBarrier, sendHanders[i],
					new IgnoreExceptionHandler(), sendSequence);
		}

		ringBuffer.addGatingSequences(getSeqAry(sendProcessors));

		for (int i = 0; i < publishers.length; i++) {
			executor.submit(publishers[i]);
		}
		for (WorkProcessor<DumpEvent> baseProcessor : baseProcessors) {
			executor.submit(baseProcessor);
		}
		for (WorkProcessor<DumpEvent> busiProcessor : busiProcessors) {
			executor.submit(busiProcessor);
		}
		for (WorkProcessor<DumpEvent> sendProcessor : sendProcessors) {
			executor.submit(sendProcessor);
		}
		addShutdownHook();
		beginTime = System.currentTimeMillis();
	}

	private Sequence[] getSeqAry(WorkProcessor<DumpEvent>[] baseProcessors) {
		Sequence[] seqAry = new Sequence[baseProcessors.length];
		for (int i = 0; i < seqAry.length; i++) {
			seqAry[i] = baseProcessors[i].getSequence();
		}
		return seqAry;
	}

	private void addShutdownHook() {
		Runtime.getRuntime().addShutdownHook(new Thread() {
			@Override
			public void run() {
				log.info("----------------------执行关闭进程 钩子开始-------------------------------------");
				// DisruptorManager.getInst().stop(); // 为什么hold住？
				updateLastId();
				log.info("----------------------执行关闭进程 钩子完成-------------------------------------");
			}
		});
	}

	private static void initMbean() throws InstanceAlreadyExistsException, MBeanRegistrationException,
			NotCompliantMBeanException, MalformedObjectNameException {
		DumpControl control = new DumpControl();
		MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
		mbs.registerMBean(control, new ObjectName("Commons:name=dumpBean"));
		log.info("----------------------MBean注册成功-------------------------------------");
	}

	private static ScheduledExecutorService timerService;

	private void addTimer() {
		timerService = Executors.newSingleThreadScheduledExecutor();
		// 第二个参数为首次执行的延时时间，第三个参数为定时执行的间隔时间
		timerService.scheduleAtFixedRate(new Runnable() {
			@Override
			public void run() {
				updateLastId();
				//2021-10-22 andy.zhou 是否结果，每秒检查一次，否则会出现，没有数据就不触发SendHander里的isOver方法而一直hold的问题
				isOver();
			}
		}, 10, 3, TimeUnit.SECONDS);
	}

	public static void shutdown() {
		try {
			executor.shutdown();
		} catch (Throwable e) {
			log.error("关闭线程池失败");
		}
		try {
			timerService.shutdown();
		} catch (Throwable e) {
			log.error("关闭定时器失败");
		}
	}

	Connection connectionChk = null;
	PreparedStatement stmt = null;

	private void updateLastId() {
		long min = ringBuffer.getMinimumGatingSequence();
		if (ArrayUtils.isEmpty(dumps)) {
			return;
		}
		long timeUse = System.currentTimeMillis() - beginTime;
		for (Dump dump : dumps) {
			double speed = metricsMap.get(dump.getId()).counter_send_num.getCount() * 1000 / timeUse;
			if (needConf) {// 配置了存储
				try {
					if (connectionChk == null || connectionChk.isClosed()) {
						connectionChk = DruidAssit.getConnection(chkDatasourceName);
						stmt = connectionChk.prepareStatement(
								"INSERT INTO `dump_lastid`(`dump_id` ,`db`,`tb`,`time`,`lastId` ,`speed` ) VALUES (?, ?, ?, ?, ?, ?)");
					}
					String curTimeStr = DateFormatCase.YYYY_MM_DD_hhmmss.getInstanc()
							.format(System.currentTimeMillis());
					JdbcAssit.setPreParam(stmt, dump.getId(), dump.getDbOri(), dump.getTbOri(), curTimeStr,
							dump.getLastId(), speed);
					stmt.execute();
				} catch (Exception e) {
					log.error("save last error", e);
				}
			} else {
				log.info("-------------------------table:{}.{}, speed:{},lastId:{}", dump.getDbOri(), dump.getTbOri(),
						speed, dump.getLastId());
			}
		}
		// 总体日志
		log.info(
				"-------------------------time:{} minute,undo size:{},sendDuanNo:{},busiDuanNo:{},baseDateDuanNo:{},publisher:{}",
				timeUse / (1000 * 60), ringBuffer.getCursor() - min, min, busiBarrier.getCursor(),
				baseBarrier.getCursor(), ringBuffer.getCursor());
	}
	
	
	private  void isOver() {
		sendHanders[0].isOver();
	}

	private static long beginTime;

	/*
	 * public static void main(String[] args) throws IOException, SQLException,
	 * InstantiationException, IllegalAccessException, ClassNotFoundException {
	 * MainDump main = new MainDump(); main.dump(); System.in.read(); }
	 */
}
