package net.wicp.tams.common.binlog.alone.proxy;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.binlog.alone.beans.RingBuffMonitor;
import net.wicp.tams.common.binlog.alone.binlog.bean.PushlishBean;
import net.wicp.tams.common.binlog.alone.constant.BuffType.BinlogListenerProxy;
import net.wicp.tams.common.constant.JvmStatus;
import net.wicp.tams.common.exception.ProjectException;

/***
 * TODO 未实现。 保证有条件顺序： 启动多个只有一个线程的线程池，并给这些线程按 1/2/3/4/5/6/7/8
 * 标好序号，只要有数据来了，监听器打开数据取出其中的id字段，如果是整形直接取模拿到序号，然后往对应的序号线程池里抛，如果是字符型就需要加一个hash再取模拿到序号。
 * 
 * @author Andy
 *
 */
@Slf4j
public class Threadpoolsingle extends BinlogListenerProxy {
	
	private final RingBuffMonitor ringBuffMonitor = new RingBuffMonitor();

	@Override
	public void close() {
		// 什么也不做
	}

	@Override
	public RingBuffMonitor getCurDoWithSize() {
		return this.ringBuffMonitor;// 单线程没有延时
	}

	@Override
	public void sendmsg(PushlishBean pushlishBean) {
		// 业务处理，有过滤处理器等内部处理
		if (pushlishBean.getBusiListener() != null) {
			try {
				pushlishBean.getBusiListener().doWith(pushlishBean);
			} catch (ProjectException e) {// 处理器失败，需要停止程序运行，可能会导致过滤数据不干净等问题
				log.error("处理失败", e);
				LoggerUtil.exit(JvmStatus.s15);
			}
		}
		pushlishBean.getBinlogListener().doBui(pushlishBean.getRule(), pushlishBean.getEventBuilder().build(), false);
	}
}
