package net.wicp.tams.common.binlog.alone.proxy;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.beans.RingBuffMonitor;
import net.wicp.tams.common.binlog.alone.binlog.bean.PushlishBean;
import net.wicp.tams.common.binlog.alone.constant.BuffType.BinlogListenerProxy;
import net.wicp.tams.common.constant.JvmStatus;
import net.wicp.tams.common.exception.ProjectException;

/***
 * 不保证顺序：启一个带阻塞功能的线程池，只要有监听数据就往线程池里丢，处理逻辑写在线程池的线程里，监听器只管生产数据给线程池就可以了。
 * 
 * @author Andy
 *
 */
@Slf4j
public class Threadpoolmuli extends BinlogListenerProxy {

	private final RingBuffMonitor ringBuffMonitor = new RingBuffMonitor();

	private final int sendNum = Conf.getInt("common.binlog.alone.binlog.global.threadpoolmuli.sendNum");

	private final ExecutorService[] executors = new ExecutorService[sendNum];

	public Threadpoolmuli() {
		for (int i = 0; i < executors.length; i++) {
			executors[i] = Executors.newSingleThreadExecutor();
		}
		ringBuffMonitor.getUndoSize().getAndSet(0l);
		ringBuffMonitor.getSenderUnit().getAndSet(0l);
	}

	@Override
	public void close() {
		for (int i = 0; i < executors.length; i++) {
			executors[i].shutdown();
		}
	}

	@Override
	public RingBuffMonitor getCurDoWithSize() {
		return this.ringBuffMonitor;
	}

	@Override
	public void sendmsg(PushlishBean pushlishBean) {
		// 业务处理，有过滤处理器等内部处理
		if (pushlishBean.getBusiListener() != null) {
			try {
				pushlishBean.getBusiListener().doWith(pushlishBean);
			} catch (ProjectException e) {// 处理器失败，需要停止程序运行，可能会导致过滤数据不干净等问题
				log.error("处理失败", e);
				LoggerUtil.exit(JvmStatus.s15);
			}
		}

		// 一条一条发送
		for (int i = 0; i < pushlishBean.getEventBuilder().getItemsCount(); i++) {
			final int ifinal = i;
			String keyjoin = DuckulaAssit.getKeyJoin(pushlishBean.getEventBuilder(), i, "`");
			int index = sendNum < 2 ? 0 : StringUtil.partition(String.valueOf(keyjoin), sendNum);
			executors[index].execute(new Runnable() {
				public void run() {
					net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent.Builder sendBuilder = DuckulaAssit
							.buildSinglItemDuckulaEvent(pushlishBean.getEventBuilder(), ifinal);
					pushlishBean.getBinlogListener().doBui(pushlishBean.getRule(), sendBuilder.build(), true);
				}
			});
		}
		this.ringBuffMonitor.getSenderUnit().incrementAndGet();
	}
}
