package net.wicp.tams.common.binlog.alone.proxy;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.binlog.alone.beans.RingBuffMonitor;
import net.wicp.tams.common.binlog.alone.binlog.bean.PushlishBean;
import net.wicp.tams.common.binlog.alone.constant.BuffType.BinlogListenerProxy;
import net.wicp.tams.common.constant.JvmStatus;
import net.wicp.tams.common.exception.ProjectException;

@Slf4j
public class No extends BinlogListenerProxy {

	private final RingBuffMonitor ringBuffMonitor = new RingBuffMonitor();

	@Override
	public void close() {
		// 什么也不做
	}

	@Override
	public RingBuffMonitor getCurDoWithSize() {
		return this.ringBuffMonitor;
	}

	@Override
	public void sendmsg(PushlishBean pushlishBean) {
		// 业务处理，有过滤处理器等内部处理
		if (pushlishBean.getBusiListener() != null) {
			try {
				pushlishBean.getBusiListener().doWith(pushlishBean);
			} catch (ProjectException e) {// 处理器失败，需要停止程序运行，可能会导致过滤数据不干净等问题
				log.error("处理失败", e);
				LoggerUtil.exit(JvmStatus.s15);
			}
		}
		pushlishBean.getBinlogListener().doBui(pushlishBean.getRule(), pushlishBean.getEventBuilder().build(), false);
	}
}
