package net.wicp.tams.common.binlog.alone.proxy;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import org.apache.commons.beanutils.BeanUtils;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.IgnoreExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WorkProcessor;
import com.lmax.disruptor.util.DaemonThreadFactory;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.binlog.alone.beans.RingBuffMonitor;
import net.wicp.tams.common.binlog.alone.binlog.bean.PushlishBean;
import net.wicp.tams.common.binlog.alone.constant.BuffType.BinlogListenerProxy;
import net.wicp.tams.common.binlog.alone.handlerConsumer.disruptor.BusiHander;
import net.wicp.tams.common.binlog.alone.handlerConsumer.disruptor.SendHander;
import net.wicp.tams.common.constant.JvmStatus;

/***
 * 保证全局有序：
 * 可以采用disruptor的ringbuff的环状缓冲池。业务注册的监听器做为生产者而消费者可以是多线程，注意它也不能保证完全的全局有序，它是分批拿给消费者的，比如有10个消费者，那么它10个一批拿给消费者，只有等10个消费者全部处理完了，再拿10给消费者，第二批可以比第一批晚招待，但是同一批的10条记录并不能保证先后顺序。
 * 
 * @author Andy
 *
 */
public class Disruptor extends BinlogListenerProxy {

	private final int BUFFER_SIZE = 256;
	private final EventFactory<PushlishBean> EVENT_FACTORY = new EventFactory<PushlishBean>() {
		public PushlishBean newInstance() {
			return new PushlishBean();
		}
	};
	private final RingBuffer<PushlishBean> ringBuffer = RingBuffer.createSingleProducer(EVENT_FACTORY, BUFFER_SIZE,
			new BlockingWaitStrategy());
	{
		///////////////////////////////// 业务处理////////////////////////////////////
		Sequence workSequence = new Sequence(-1);
		SequenceBarrier sequenceBarrier = this.ringBuffer.newBarrier();
		int busiNum = Conf.getInt("common.binlog.alone.binlog.global.disruptor.busiNum").intValue();
		BusiHander[] busiHanders = new BusiHander[busiNum];
		for (int i = 0; i < busiHanders.length; i++) {
			busiHanders[i] = new BusiHander();
		}
		@SuppressWarnings("unchecked")
		WorkProcessor<PushlishBean>[] busiProcessors = new WorkProcessor[busiNum];
		for (int i = 0; i < busiProcessors.length; i++) {
			busiProcessors[i] = new WorkProcessor<PushlishBean>(ringBuffer, sequenceBarrier, busiHanders[i],
					new IgnoreExceptionHandler(), workSequence);
		}
		///////////////////////////////////////// 发送处理///////////////////////////////////////////////////////////////////////////////
		SequenceBarrier busiBarrier = ringBuffer.newBarrier(getSeqAry(busiProcessors));
		Sequence sendSequence = new Sequence(-1);
		// 不需要发送只要一个线程就OK了
		int sendNum = Conf.getInt("common.binlog.alone.binlog.global.disruptor.sendNum").intValue();
		SendHander[] sendHanders = new SendHander[sendNum];
		for (int i = 0; i < sendHanders.length; i++) {
			sendHanders[i] = new SendHander();
		}
		@SuppressWarnings("unchecked")
		WorkProcessor<PushlishBean>[] sendProcessors = new WorkProcessor[sendNum];
		for (int i = 0; i < sendProcessors.length; i++) {
			sendProcessors[i] = new WorkProcessor<PushlishBean>(ringBuffer, busiBarrier, sendHanders[i],
					new IgnoreExceptionHandler(), sendSequence);
		}

		this.ringBuffer.addGatingSequences(getSeqAry(sendProcessors));

		ExecutorService executor = Executors.newFixedThreadPool(busiNum + sendNum, DaemonThreadFactory.INSTANCE);
		for (WorkProcessor<PushlishBean> busiProcessor : busiProcessors) {
			executor.submit(busiProcessor);
		}
		for (WorkProcessor<PushlishBean> sendProcessor : sendProcessors) {
			executor.submit(sendProcessor);
		}
	}

	@Override
	public void close() {
		// 什么也不做
	}

	private Sequence[] getSeqAry(WorkProcessor<PushlishBean>[] baseProcessors) {
		Sequence[] seqAry = new Sequence[baseProcessors.length];
		for (int i = 0; i < seqAry.length; i++) {
			seqAry[i] = baseProcessors[i].getSequence();
		}
		return seqAry;
	}

	@Override
	public RingBuffMonitor getCurDoWithSize() {
		long min = this.ringBuffer.getMinimumGatingSequence();
		long cursor = this.ringBuffer.getCursor();
		RingBuffMonitor retobj = new RingBuffMonitor();
		retobj.getUndoSize().getAndSet(cursor - min);
		retobj.getSenderUnit().getAndSet(min);
		return retobj;
	}

	@Override
	public void sendmsg(PushlishBean pushlishBean) {
		long sequence = this.ringBuffer.next();
		PushlishBean pushlishBeanBuff = this.ringBuffer.get(sequence);
		try {
			BeanUtils.copyProperties(pushlishBeanBuff, pushlishBean);
		} catch (Exception e) {
			e.printStackTrace();
			LoggerUtil.exit(JvmStatus.s15);
		}
		this.ringBuffer.publish(sequence);
	}
}
