package net.wicp.tams.common.binlog.alone.jmx;

import lombok.Data;
import net.wicp.tams.common.binlog.alone.parser.ParseLogOnline;

@Data
public class BinlogControl implements BinlogControlMBean {
	private final ParseLogOnline parseLogOnline;

	public BinlogControl(ParseLogOnline parseLogOnline) {
		this.parseLogOnline = parseLogOnline;
	}

	// long类型也不支持export，只支持int和double ,int能支持68年，到2038
	@Override
	public String getCurPos() {
		return this.parseLogOnline.getCurpos().getTimeStr();
	}

	@Override
	public int getUndoSize() {
		long undoSize = this.parseLogOnline.getBuffType().getBinlogListenerProxy().getCurDoWithSize().getUndoSize().get();
		return new Long(undoSize).intValue();
	}

	@Override
	public int getDelayTime() {
		long deff = System.currentTimeMillis() - this.parseLogOnline.getCurpos().getTime();
		return new Long(deff).intValue();
	}

}
