package net.wicp.tams.common.binlog.alone.handlerConsumer.disruptor;

import java.util.Map;

import com.lmax.disruptor.WorkHandler;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.apiext.TimeAssist;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEventItem;
import net.wicp.tams.common.binlog.alone.ListenerConf.OptType;
import net.wicp.tams.common.binlog.alone.binlog.bean.PushlishBean;
import net.wicp.tams.common.constant.JvmStatus;

@Slf4j
public class SendHander implements WorkHandler<PushlishBean> {

	@Override
	public void onEvent(final PushlishBean data) throws Exception {
		Thread.currentThread().setName("binlog-SendHanderThread");
		if (data.isBreak() || data.getBinlogListener() == null || data.getEventBuilder().getItemsCount() == 0) {
			return;
		}
		while (true) {
			try {
				// 发送前检查版本
				for (int i = data.getEventBuilder().getItemsCount() - 1; i >= 0; i--) {
					DuckulaEventItem item = data.getEventBuilder().getItems(i);

					Map<String, String> datamap = data.getEventBuilder().getOptType() == OptType.delete
							? item.getBeforeMap()
							: item.getAfterMap();
					String idstr = datamap.get(data.getEventBuilder().getCols(0));
					if (data.getVersionMap().containsKey(idstr)
							&& data.getVersionMap().get(idstr) > item.getVersion()) {
						data.getEventBuilder().removeItems(i);
						log.warn("id:{},exit:{},cur:{},The version was ignored because it was too old.", idstr,
								data.getVersionMap().get(idstr), item.getVersion());
					}
				}
				if (data.getEventBuilder().getItemsCount() > 0) {
					data.getBinlogListener().doBui(data.getRule(), data.getEventBuilder().build(), false);
				}
				break;
			} catch (Throwable e) {
				boolean reDoWait = TimeAssist.reDoWait("tams-binloglistener", 7);
				if (reDoWait) {// 达到最大值就出
					log.error("重试7次都不能拿到链接，退出");
					LoggerUtil.exit(JvmStatus.s15);
				} else {
					log.error("不能发送数据，重试", e);
					continue;
				}
			}
		}
	}
}
