package net.wicp.tams.common.binlog.alone.handlerConsumer.disruptor;

import com.lmax.disruptor.WorkHandler;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.binlog.alone.binlog.bean.PushlishBean;
import net.wicp.tams.common.constant.JvmStatus;
import net.wicp.tams.common.exception.ProjectException;

@Slf4j
public class BusiHander implements WorkHandler<PushlishBean> {
	@Override
	public void onEvent(final PushlishBean events) throws Exception {
		Thread.currentThread().setName("binlog-BusiHanderThread");
		// 业务处理，有过滤处理器等内部处理
		if (events.getBusiListener() != null) {
			try {
				events.getBusiListener().doWith(events);
			} catch (ProjectException e) {// 处理器失败，需要停止程序运行，可能会导致过滤数据不干净等问题
				log.error("处理失败", e);
				LoggerUtil.exit(JvmStatus.s15);
			}
		}
		if (!events.isBreak() && events.getBusiListener() != null) {
			events.getBusiListener().doWith(events);
		}
	}
}
