package net.wicp.tams.common.binlog.alone.handlerConsumer.commonBusi;

import java.util.Properties;

import javax.sql.DataSource;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.binlog.alone.Config;
import net.wicp.tams.common.binlog.alone.ListenerConf.ConnConf;
import net.wicp.tams.common.binlog.alone.binlog.bean.PushlishBean;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleFilter;
import net.wicp.tams.common.binlog.alone.binlog.listener.AbsBusi;
import net.wicp.tams.common.binlog.alone.constant.FilterPattern;
import net.wicp.tams.common.jdbc.DruidAssit;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;

/***
 * 装饰器模式：处理过虑数据
 * 
 * @author Andy
 *
 */
@Slf4j
public class FilterBusi extends AbsBusi {

	public FilterBusi(AbsBusi busi, ConnConf connConf) {
		super(busi, connConf);
		log.info("---------------------初始化完成-----------------------");
	}

	@Override
	public void doSelf(PushlishBean pushlishBean) {
		if (pushlishBean.isBreak()) {
			return;
		}
		for (RuleFilter filterRulePo : pushlishBean.getRule().getFilterRules()) {
			if (filterRulePo.getFilterPattern() == FilterPattern.sql) {// 初始化连接池
				Properties props = new Properties();
				props.put("host", super.connConf.getHost());
				props.put("port", super.connConf.getPort());
				props.put("username", super.connConf.getUsername());
				props.put("password", super.connConf.getPassword());
				DataSource dataSourceNoConf = DruidAssit.getDataSourceNoConf(super.connConf.getConfName(), props);
				PerthreadManager.getInstance().createValue(Config.CurThreadDatasourceName, DataSource.class)
						.set(dataSourceNoConf);
			}
			filterRulePo.getFilterPattern().getFilter().doFilter(pushlishBean.getEventBuilder(), pushlishBean.getRule(),
					filterRulePo);
			if (pushlishBean.getEventBuilder().getItemsCount() == 0) {
				pushlishBean.setBreak(true);
				log.info("---------------------过滤后没有处理的数据-----------------------------");
				break;
			}
		}
	}

}
