package net.wicp.tams.common.binlog.alone.constant;

import java.util.Arrays;
import java.util.Comparator;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.binlog.alone.ListenerConf.ConnConf;
import net.wicp.tams.common.binlog.alone.binlog.listener.AbsBusi;
import net.wicp.tams.common.binlog.alone.handlerConsumer.commonBusi.FilterBusi;

/***
 * 内置的处理器
 * 
 * @author Andy
 *
 */
@Slf4j
public enum BusiAdapt {
	// 默认是没有自定义的处理器的，如果需要配置，则设置好className和order
	cus("自定义处理器", null, 2),

	filter("过滤器", FilterBusi.class, 1);

	private final String desc;
	private Class<?> calssz;

	private int order;

	private BusiAdapt(String desc, Class<?> calssz, int order) {
		this.desc = desc;
		this.calssz = calssz;
		this.order = order;
	}

	public static BusiAdapt get(String name) {
		for (BusiAdapt checksum : BusiAdapt.values()) {
			if (checksum.name().equalsIgnoreCase(name)) {
				return checksum;
			}
		}
		return null;
	}

	public String getDesc() {
		return desc;
	}

	public static void setCusClassName(Class<?> calssz, int order) {
		BusiAdapt.cus.calssz = calssz;
		BusiAdapt.cus.order = order;
	}
	
	public static void setCusClassName(Class<?> calssz) {
		BusiAdapt.cus.calssz = calssz;
	}

	public static BusiAdapt[] getAllBusiAdaptAry() {
		BusiAdapt[] retAry = BusiAdapt.values();
		Arrays.sort(retAry, new Comparator<BusiAdapt>() {
			@Override
			public int compare(BusiAdapt o1, BusiAdapt o2) {
				return o1.order - o2.order;
			}
		});
		return retAry;
	}

	/***
	 * 内部处理器构造，装饰模式
	 * 
	 * @param connConf
	 * @return
	 */
	public static synchronized AbsBusi putInnerBusis(ConnConf connConf) {
		BusiAdapt[] busiAdapts = BusiAdapt.getAllBusiAdaptAry();
		try {
			AbsBusi finalBusi = null;
			for (int i = 0; i < busiAdapts.length; i++) {
				if (busiAdapts[i].getCalssz() != null) {
					finalBusi = (AbsBusi) busiAdapts[i].getCalssz().getConstructor(AbsBusi.class, ConnConf.class)
							.newInstance(finalBusi, connConf);
				}
			}
			return finalBusi;
		} catch (Exception e) {
			log.error("错误构建AbsBusi", e);
			return null;
		}
	}

	public int getOrder() {
		return order;
	}

	public void setOrder(int order) {
		this.order = order;
	}

	public Class<?> getCalssz() {
		return calssz;
	}

}
