package net.wicp.tams.common.binlog.alone.constant;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.apiext.MaxSizeHashMap;
import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf.ConnConf;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEventItem.Builder;
import net.wicp.tams.common.binlog.alone.beans.RingBuffMonitor;
import net.wicp.tams.common.binlog.alone.binlog.bean.PushlishBean;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.listener.AbsBusi;
import net.wicp.tams.common.binlog.alone.binlog.listener.IBinlogListener;
import net.wicp.tams.common.constant.JvmStatus;

/**
 * 消费者加速器
 * 
 * @author andy.zhou
 *
 */
@Slf4j
public enum BuffType {
	disruptor("全局有序", "net.wicp.tams.common.binlog.alone.proxy.Disruptor"),

	threadpoolsingle("不保证顺序", "net.wicp.tams.common.binlog.alone.proxy.Threadpoolsingle"),

	threadpoolmuli("条件顺序", "net.wicp.tams.common.binlog.alone.proxy.Threadpoolmuli"),

	no("不使用加速器", "net.wicp.tams.common.binlog.alone.proxy.No");

	private final String desc;

	private final String binlogListenerProxyClass;

	private BinlogListenerProxy binlogListenerProxy;

	public BinlogListenerProxy getBinlogListenerProxy() {
		if (this.binlogListenerProxy == null) {
			try {
				this.binlogListenerProxy = (BinlogListenerProxy) Class.forName(this.binlogListenerProxyClass)
						.newInstance();
			} catch (Exception e) {
				log.error("创建代理类失败", e);
				LoggerUtil.exit(JvmStatus.s15);
			}
		}
		return binlogListenerProxy;
	}

	private BuffType(String desc, String binlogListenerProxyClass) {
		this.desc = desc;
		this.binlogListenerProxyClass = binlogListenerProxyClass;
	}

	public static BuffType get(String name) {
		for (BuffType checksum : BuffType.values()) {
			if (checksum.name().equalsIgnoreCase(name)) {
				return checksum;
			}
		}
		return no;
	}

	public String getDesc() {
		return desc;
	}

	public static abstract class BinlogListenerProxy {
		private final Map<String, IBinlogListener> listermap = new HashMap<String, IBinlogListener>();

		private final Map<String, AbsBusi> doWithMap = new HashMap<String, AbsBusi>();
		
		public void putIBinlogListener(String host, IBinlogListener binlogListener) {
			this.listermap.put(host, binlogListener);
		}

		public IBinlogListener getIBinlogListener(String host) {
			return this.listermap.get(host);
		}

		// 需要先添加CusBusi
		public synchronized void putBusiDowithAdapt(ConnConf connConf) {			
			AbsBusi innerBusis = BusiAdapt.putInnerBusis(connConf);			
			doWithMap.put(connConf.getHost(), innerBusis);
		}

		protected abstract void sendmsg(PushlishBean pushlishBean);

		private volatile MaxSizeHashMap<String, Long> versionMap = new MaxSizeHashMap<String, Long>(10000);

		public final void sendmsg(String host, Rule rule, DuckulaEvent.Builder duckulaEventBuilder) {			
			// 组装发送信息
			PushlishBean pushlishBean = new PushlishBean();
			pushlishBean.setRule(rule);
			pushlishBean.setEventBuilder(duckulaEventBuilder);
			pushlishBean.setBinlogListener(this.listermap.get(host));
			pushlishBean.setBusiListener(this.doWithMap.get(host));
			pushlishBean.setVersionMap(versionMap);
			// 每发一个事件打一下日志
			StringBuffer buff = new StringBuffer();
			for (int i = 0; i < duckulaEventBuilder.getItemsCount(); i++) {
				Builder duckulaEventItem = duckulaEventBuilder.getItemsBuilder(i);
				// 设置
				Serializable key = DuckulaAssit.getKeyJoin(duckulaEventBuilder, i, "`");
				String idstr = String.valueOf(key);
				buff.append(idstr);
				buff.append(",");
				// gtid的long型不能用，做了主备切换后可能会导致数据不能更新
				long logicDotrans = duckulaEventBuilder.getCommitTime();
				if (versionMap.containsKey(idstr)) {//
					if (versionMap.get(idstr) / 1000 == logicDotrans / 1000) {// 同一秒种提交的
						logicDotrans = versionMap.get(idstr) + 1;
						versionMap.put(idstr, logicDotrans);
					} else {// 不同一秒种提交的
						versionMap.put(idstr, logicDotrans);// 打一个版本号
					}
				} else {
					versionMap.put(idstr, logicDotrans);// 打一个版本号
				}
				duckulaEventItem.setVersion(logicDotrans);
			}
			log.info("sendmsg table:{} count:{} ids:{}", pushlishBean.getEventBuilder().getTb(),
					pushlishBean.getEventBuilder().getItemsCount(), buff.toString());

			sendmsg(pushlishBean);
		}

		// 得到未处理的数量
		public abstract RingBuffMonitor getCurDoWithSize();

		public abstract void close();
	}

}
