package net.wicp.tams.common.binlog.alone.checkpoint;

import java.util.ArrayList;
import java.util.List;

import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.zookeeper.data.Stat;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.ListenerConf.ColHis;
import net.wicp.tams.common.binlog.alone.ListenerConf.ConnConf;
import net.wicp.tams.common.binlog.alone.ListenerConf.Position;
import net.wicp.tams.common.binlog.alone.PluginAssit;
import net.wicp.tams.common.binlog.alone.binlog.listener.ISaveCheckPoint;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.others.ZkClient;

@Slf4j
public class CheckPointZookeeper implements ISaveCheckPoint {

	private ConnConf connConf;

	private final String defaultRootpath = "/duckula3";

	private final String defaultPositionpath = "pos";

	private final String defaultColpath = "cols";

	private final String defaultLockpath = "lock";

	private String rootPath = defaultRootpath;

	private String pospath = null;

	private String colspath = null;

	private String lockpath = null;// 当前实例的锁路径

	@Override
	public void init(ConnConf.Builder connConfBuilder) {
		String constr = Conf.get("common.others.zookeeper.constr");
		log.info("the constr is:{}", constr);
		if (StringUtil.isNull(Conf.get("common.binlog.alone.binlog.global.chk.zookeeper.rootpath"))) {
			log.warn(
					"please set the common.binlog.alone.binlog.global.chk.zookeeper.rootpath ,the default rootpath '{}' is used.",
					defaultRootpath);
		} else {
			this.rootPath = Conf.get("common.binlog.alone.binlog.global.chk.zookeeper.rootpath");
		}
		this.pospath = IOUtil.mergeFolderAndFilePath(this.rootPath, connConfBuilder.getHost(),
				this.defaultPositionpath);
		ZkClient.getInst().createMultilevelNode(this.pospath);
		this.colspath = IOUtil.mergeFolderAndFilePath(this.rootPath, connConfBuilder.getHost(), this.defaultColpath);
		ZkClient.getInst().createMultilevelNode(this.colspath);
		this.lockpath = IOUtil.mergeFolderAndFilePath(this.rootPath, connConfBuilder.getHost(), this.defaultLockpath,
				connConfBuilder.getGroupId());
		ZkClient.getInst().createMultilevelNode(this.lockpath);
		this.connConf = connConfBuilder.build();
	}

	@Override
	public void shutdown() {
		log.info("the connection is closed");
	}

	@Override
	public void savePoint(Position pos) {
		ZkClient.getInst().createOrUpdateNodeForJson(
				IOUtil.mergeFolderAndFilePath(this.pospath, String.valueOf(pos.getTime())), PluginAssit.toJsonStr(pos));
		log.info("保存实例:{} 位点{}成功", pos.getServerIp(), pos.getGtids());
	}

	@Override
	public void saveColName(ColHis colHis) {
		ZkClient.getInst().createOrUpdateNodeForJson(IOUtil.mergeFolderAndFilePath(this.colspath, colHis.getDb(),
				colHis.getTb(), String.valueOf(colHis.getTime())), PluginAssit.toJsonStr(colHis));
		log.info("保存字段名成功,db{},tb{},time{}", colHis.getDb(), colHis.getTb(), colHis.getTime());
	}

	@Override
	public Position findPoint(long time) {
		List<String> times = ZkClient.getInst().getChildren(IOUtil.mergeFolderAndFilePath(this.pospath));
		long cur = -1;
		for (String timestr : times) {
			long eletime = Long.parseLong(timestr);
			if (eletime <= time) {
				if (cur == -1) {
					cur = eletime;
				} else {
					if (eletime > cur) {
						cur = eletime;
					}
				}
			}
		}
		if (cur == -1) {
			return null;
		}
		String jsonstr = ZkClient.getInst().getZkDataStr(IOUtil.mergeFolderAndFilePath(this.pospath, String.valueOf(cur)));
		Position dateObj = PluginAssit.toMessage(jsonstr, Position.class);
		return dateObj;
	}

	@Override
	public List<ColHis> findColsList(String db, String tb) {
		List<ColHis> retlist = new ArrayList<ColHis>();
		String parentPath = IOUtil.mergeFolderAndFilePath(this.colspath, db, tb);
		Stat exists = ZkClient.getInst().exists(parentPath);
		if (exists == null) {
			ZkClient.getInst().createMultilevelNode(parentPath);
			return retlist;
		}
		List<String> times = ZkClient.getInst().getChildren(parentPath);
		for (String timestr : times) {
			String jsonstr = ZkClient.getInst().getZkDataStr(IOUtil.mergeFolderAndFilePath(this.colspath, db, tb, timestr));
			ColHis dateObj = PluginAssit.toMessage(jsonstr, ColHis.class);
			retlist.add(dateObj);
		}
		return retlist;
	}

	@Override
	public List<ColHis> findColsAll() {
		List<ColHis> retlist = new ArrayList<>();
		List<String> dbs = ZkClient.getInst()
				.getChildren(IOUtil.mergeFolderAndFilePath(this.colspath, connConf.getHost()));
		for (String db : dbs) {
			List<String> tbs = ZkClient.getInst()
					.getChildren(IOUtil.mergeFolderAndFilePath(this.colspath, connConf.getHost(), db));
			for (String tb : tbs) {
				List<String> times = ZkClient.getInst()
						.getChildren(IOUtil.mergeFolderAndFilePath(this.colspath, connConf.getHost(), db, tb));
				for (String timestr : times) {
					ColHis dateObj = ZkClient.getInst().getDateObj(
							IOUtil.mergeFolderAndFilePath(this.colspath, connConf.getHost(), db, tb, timestr),
							ColHis.class);
					retlist.add(dateObj);
				}
			}
		}
		return retlist;
	}

	private InterProcessMutex lock;

	// 获取分布式锁
	@Override
	public YesOrNo acquireLock() {
		log.info("----------------------开始获得分布式锁-------------------------------------");
		try {
			lock = ZkClient.getInst().lockPath(this.lockpath, 30000l);// 只等半分钟就好了
		} catch (Exception e1) {
			log.error("获取锁异常", e1);
			return YesOrNo.no;
		}
		if (lock == null) {
			log.error("未获得分布式锁");
			return YesOrNo.no;
		}
		return YesOrNo.yes;
	}

	// 释放分布式锁
	@Override
	public void releaseLock() {
		try {
			lock.release();
		} catch (Exception e) {
			log.error("释放锁失败", e);
		}
	}
}
