package net.wicp.tams.common.binlog.alone.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.OSinfo;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.BinlogStart;
import net.wicp.tams.common.binlog.alone.BusiAssit;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.spring.autoconfig.beans.TypeBean;

public class BinlogListenerDo extends TypeBean<Object> {
	private final static List<String> confs = new ArrayList<String>();

	public BinlogListenerDo(Annotation annotationInst) {
		super(annotationInst);
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		BinlogListener binlogListener = (BinlogListener) super.annotationInst;
		if (binlogListener != null) {
			Map<String, String> confspring = null;
			if (StringUtil.isNull(binlogListener.ip()) || StringUtil.isNull(binlogListener.user())
					|| StringUtil.isNull(binlogListener.password())) {
				if (StringUtil.isNull(Conf.get("common.spring.autoconfig.addPre"))) {
					throw new ProjectException(ExceptAll.param_error,
							"请配置监听地址或spring相关的配置信息“common.spring.autoconfig.addPre”");
				}
				confspring = Conf.getPre(Conf.get("common.spring.autoconfig.addPre"), true);
			}

			Properties props = new Properties();
			String preStr = String.format("common.binlog.alone.binlog.conf.%s.", binlogListener.conf());
			if (StringUtil.isNotNull(binlogListener.groupId())) {
				props.put(preStr + "groupId", binlogListener.groupId());
			} else {
				props.put(preStr + "groupId", "group-" + binlogListener.conf());// 默认配置上groupid
			}
			if (StringUtil.isNotNull(binlogListener.haType())) {
				props.put(preStr + "haType", binlogListener.haType());
			}
			props.put(preStr + "chk", binlogListener.chk());
			if (StringUtil.isNotNull(binlogListener.ip())) {
				props.put(preStr + "host", binlogListener.ip());
				props.put(preStr + "port", String.valueOf(binlogListener.port()));
			} else {
				String url = confspring.get("url");
				if (StringUtil.isNotNull(url)) {
					int indexOf = url.indexOf("//");
					url = url.substring(indexOf + 2, url.indexOf("/", indexOf + 2));
					String[] arys = url.split(":");
					props.put(preStr + "host", arys[0]);
					props.put(preStr + "port", arys[1]);
				}
			}

			if (StringUtil.isNotNull(binlogListener.user())) {
				props.put(preStr + "username", binlogListener.user());
			} else {
				props.put(preStr + "username", confspring.get("username"));
			}
			if (StringUtil.isNotNull(binlogListener.password())) {
				props.put(preStr + "password", binlogListener.password());
			} else {
				props.put(preStr + "password", confspring.get("password"));
			}
			if (StringUtil.isNotNull(binlogListener.rule())) {
				props.put(preStr + "rule", binlogListener.rule());
			}
			props.put(preStr + "rds", StringUtil.hasNull(String.valueOf(binlogListener.rds()), "false"));

			// clientid，如果没有传入，就用本机ip地址build一个端口
			props.put(preStr + "clientId", binlogListener.clientId() > 0 ? binlogListener.clientId()
					: String.valueOf(StringUtil.buildPort(OSinfo.findIpAddressTrue())));

			if (StringUtil.isNotNull(binlogListener.pos_gtids())) {
				props.put(preStr + "pos.gtids", binlogListener.pos_gtids());
			}
			props.put(preStr + "listener", super.getRef().getClass().getName());// 添加监听类
			try {
				String confId = binlogListener.conf();
				if (confs.contains(confId)) {
					throw new RuntimeException("已启动此confId的配置，请检查有相同的confId:【" + confId + "】");
				}
				Conf.overProp(props);
				BinlogStart.listeningNonBlocking(BusiAssit.configMap(confId));
				confs.add(confId);
			} catch (Exception e) {// 可能没有引入common-binlog-alone
				throw new ProjectExceptionRuntime(ExceptAll.project_nosupport, e);
			}
		}

	}

}
