package net.wicp.tams.common.binlog.alone.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/***
 * 
 * binlog监听，需要引入common-binlog-alone包
 * 
 * @author zhoujunhui
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.TYPE })
public @interface BinlogListener {
	String conf();// 监听的配置信息 ,注意不能重复。default默认

	String groupId() default "null";// 分布式锁用的组

	String haType() default "last";

	String chk() default "net.wicp.tams.common.binlog.alone.checkpoint.CheckPointH2db";

	String ip() default "null";

	int port() default 3306;

	String user() default "null";

	String password() default "null";

	String rule();// rule = "pv-demo`t_sample``{}`" 1:db 2:tb 3:drds 4:rule 5:filter

	boolean rds() default false;

	int clientId() default 0;

	String pos_gtids() default "null";

}
