package net.wicp.tams.common.binlog.alone;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.Tools;
import net.wicp.tams.common.binlog.alone.ListenerConf.ConnConf;
import net.wicp.tams.common.binlog.alone.parser.BaseLogFetcher;
import net.wicp.tams.common.binlog.alone.parser.ParseLogOnline;

@Slf4j
public abstract class BinlogStart {


// 通过配置去监听任务
	public static void listening(ConnConf.Builder connConfBuilder) {
		BaseLogFetcher logFetcher = new ParseLogOnline(connConfBuilder);
		logFetcher.read();
	}

	public static void listeningNonBlocking(final ConnConf.Builder connConfBuilder) {
		if(StringUtil.isNull(connConfBuilder.getHost())) {
			log.error("the listener is Error,no ip config:{}",connConfBuilder.getConfName());
			return;
		}
		
		Thread listenThread = new Thread(new Runnable() {
			@Override
			public void run() {
				listening(connConfBuilder);
			}
		});
		listenThread.setName("binlogListener:"+connConfBuilder.getConfName());
		listenThread.setDaemon(true);
		listenThread.start();
		Tools.printAscill();
	}

}
