/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone.parser;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.apiext.jdbc.JdbcConnection;
import net.wicp.tams.common.binlog.alone.BusiAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.parser.BaseLogFetcher;
import net.wicp.tams.common.binlog.parser.DirectLogFetcher;
import net.wicp.tams.common.binlog.parser.LogBuffer;
import net.wicp.tams.common.binlog.parser.LogContext;
import net.wicp.tams.common.binlog.parser.LogDecoder;
import net.wicp.tams.common.binlog.parser.LogEvent;
import net.wicp.tams.common.binlog.parser.event.DeleteRowsLogEvent;
import net.wicp.tams.common.binlog.parser.event.GtidLogEvent;
import net.wicp.tams.common.binlog.parser.event.QueryLogEvent;
import net.wicp.tams.common.binlog.parser.event.RotateLogEvent;
import net.wicp.tams.common.binlog.parser.event.RowsLogEvent;
import net.wicp.tams.common.binlog.parser.event.UpdateRowsLogEvent;
import net.wicp.tams.common.binlog.parser.event.WriteRowsLogEvent;
import net.wicp.tams.common.binlog.parser.event.XidLogEvent;
import net.wicp.tams.common.constant.OptType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseLogOnline
extends BaseLogFetcher {
    private static final Logger log = LoggerFactory.getLogger(ParseLogOnline.class);
    private Connection conn;
    private String uuid;
    private String slaveGtids;
    private boolean gtidCan;
    private ListenerConf.Position posPre;
    private DirectLogFetcher fecther;
    private ListenerConf.Position.Builder curpos;
    private ListenerConf.Position.Builder savepos;
    ScheduledExecutorService timerService;
    ScheduledFuture<?> scheduleAtFixedRate = null;
    private int max = 8;
    private boolean isClose = false;

    public ParseLogOnline(ListenerConf.ConnConf.Builder connConfBuilder) {
        super(connConfBuilder);
    }

    @Override
    protected void init(ListenerConf.ConnConf.Builder connConfBuilder) {
        if (!connConfBuilder.hasPos()) {
            connConfBuilder.setPos(this.getMastStatus(connConfBuilder));
        }
        this.curpos = connConfBuilder.getPosBuilder().clone();
        try {
            Class.forName("com.mysql.jdbc.Driver");
            this.conn = DriverManager.getConnection(String.format("jdbc:mysql://%s:%s", connConfBuilder.getIp(), connConfBuilder.getPort()), connConfBuilder.getUser(), connConfBuilder.getPassword());
            Statement statement = this.conn.createStatement();
            statement.execute("SET @master_binlog_checksum='@@global.binlog_checksum'");
            statement.execute("SET @mariadb_slave_capability='4'");
            statement.close();
            this.uuid = this.getVar(this.conn, "server_uuid", false);
            this.gtids = connConfBuilder.getPos().getGtids();
            this.fileName = connConfBuilder.getPos().getFileName();
            this.initSlaveGtids(connConfBuilder.getPos().getGtids());
            this.gtidCan = this.isAvailable(this.conn, connConfBuilder.getPos().getGtids(), this.uuid);
            log.info("gtid\uff1a[{}]\u662f\u5426\u53ef\u7528\uff1a[{}]", (Object)connConfBuilder.getPos().getGtids(), (Object)this.gtidCan);
        }
        catch (Exception e) {
            log.error("\u8bfbbinlog\u65e5\u5fd7\u51fa\u73b0\u95ee\u9898", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.addTimer();
    }

    private void addTimer() {
        this.timerService = Executors.newSingleThreadScheduledExecutor();
        this.scheduleAtFixedRate = this.timerService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ParseLogOnline.this.savepos != null) {
                        ParseLogOnline.this.saveCheckPoint.savePoint(ParseLogOnline.this.savepos.build());
                    }
                }
                catch (Throwable e) {
                    log.error("save point error:", e);
                }
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public boolean isClose() {
        return this.isClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read() {
        int sendNum = 0;
        int timeout = 1;
        while (!this.isClose) {
            if (sendNum >= this.max) {
                log.error("\u7f51\u7edc\u51fa\u73b0\u95ee\u9898\uff0c\u9700\u8981\u8054\u7cfb\u76f8\u5173\u4eba\u5458");
                break;
            }
            try {
                this.readDo();
            }
            catch (Throwable e) {
                log.error("readdo error", e);
            }
            finally {
                if (this.isClose) continue;
                ++sendNum;
                try {
                    Thread.sleep(timeout * 1000);
                }
                catch (InterruptedException interruptedException) {}
                log.error("\u7b2c[{}]\u6b21\u53d1\u9001\u5931\u8d25\uff0c\u7b49\u5f85\u65f6\u95f4\uff1a[{}].\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u3002", (Object)sendNum, (Object)timeout);
                timeout *= 2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDo() {
        if (StringUtil.isNull((Object)this.connConf.getPos().getGtids()) && this.connConf.getPos().getPos() < 4L) {
            throw new IllegalAccessError("\u5f00\u59cb\u4f4d\u7f6e\u6700\u5c0f\u4e3a4");
        }
        this.fecther = new DirectLogFetcher();
        try {
            this.fetchLog();
            LogDecoder decoder = new LogDecoder(0, 164);
            LogContext context = new LogContext();
            boolean isSel = false;
            while (this.fecther.fetch()) {
                this.metric.meter_parser_pack_all.mark();
                LogEvent event = null;
                event = decoder.decode((LogBuffer)this.fecther, context);
                if (event == null) continue;
                int eventType = event.getHeader().getType();
                switch (eventType) {
                    case 15: {
                        break;
                    }
                    case 4: {
                        this.fileName = ((RotateLogEvent)event).getFilename();
                        break;
                    }
                    case 23: 
                    case 30: {
                        if (this.gtids == null || !this.parseRowsEvent((RowsLogEvent)((WriteRowsLogEvent)event), OptType.insert)) break;
                        isSel = true;
                        this.savepos = this.curpos.clone();
                        break;
                    }
                    case 24: 
                    case 31: {
                        if (this.gtids == null || !this.parseRowsEvent((RowsLogEvent)((UpdateRowsLogEvent)event), OptType.update)) break;
                        isSel = true;
                        this.savepos = this.curpos.clone();
                        break;
                    }
                    case 25: 
                    case 32: {
                        if (this.gtids == null || !this.parseRowsEvent((RowsLogEvent)((DeleteRowsLogEvent)event), OptType.delete)) break;
                        isSel = true;
                        this.savepos = this.curpos.clone();
                        break;
                    }
                    case 2: {
                        this.parseQueryEvent((QueryLogEvent)event);
                        break;
                    }
                    case 16: {
                        if (this.gtids == null || !isSel) break;
                        this.parseXidEvent((XidLogEvent)event);
                        isSel = false;
                        break;
                    }
                    case 33: {
                        this.parseGtidLogEvent((GtidLogEvent)event);
                        break;
                    }
                }
            }
        }
        catch (SQLException e) {
            log.error("\u5f97\u5230\u8054\u63a5\u9519\u8bef", (Throwable)e);
        }
        catch (IOException e) {
            if (e.getMessage().contains("errno = 1236, sqlstate = HY000")) {
                // empty if block
            }
            log.error("\u62c9\u53d6\u65e5\u5fd7\u6587\u4ef6\u9519\u8bef", (Throwable)e);
        }
        catch (Throwable e) {
            log.error("\u672a\u77e5\u9519\u8bef", e);
        }
        finally {
            try {
                this.fecther.close();
            }
            catch (IOException e) {
                log.error("\u5173\u95edfecther\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void fetchLog() throws IOException, CloneNotSupportedException {
        boolean useGtid = true;
        boolean needSecond = false;
        try {
            if (this.gtidCan) {
                this.fecther.openGtid(this.conn, this.gtids, this.connConf.getClientId());
            } else {
                useGtid = false;
                this.fetchLogFroPos();
            }
        }
        catch (Exception e) {
            log.error("\u7b2c\u4e00\u6b21\u542f\u52a8\u5931\u8d25\uff0c\u4f7f\u7528gtid:" + useGtid, (Throwable)e);
            needSecond = true;
        }
        if (needSecond) {
            if (useGtid) {
                this.fetchLogFroPos();
            } else {
                this.fecther.openGtid(this.conn, this.gtids, this.connConf.getClientId());
            }
        }
    }

    private void fetchLogFroPos() throws IOException {
        long filePosition = this.connConf.getPos().getPos();
        if (this.posPre != null) {
            int upPos = 10000;
            filePosition = this.connConf.getPos().getPos() > (long)(upPos + 4) ? this.connConf.getPos().getPos() - (long)upPos : this.connConf.getPos().getPos();
            log.warn("\u5df2\u505a\u4e3b\u5907\u5207\u6362\uff0c\u4f46\u4e0d\u652f\u6301Gtid\uff0c\u91c7\u7528\u56de\u671410000\u4f4d\u70b9\u7684\u65b9\u5f0f");
        }
        this.fecther.open(this.conn, this.connConf.getPos().getFileName(), filePosition, this.connConf.getClientId());
    }

    @Override
    protected void parseGtidLogEventSub(GtidLogEvent event) {
        if (StringUtil.isNotNull((Object)this.uuid) && this.uuid.equals(event.getSource())) {
            if (StringUtil.isNotNull((Object)this.slaveGtids)) {
                this.gtids = String.format("%s,%s", this.gtids, this.slaveGtids);
            }
            this.curpos.setGtids(this.gtids);
            this.curpos.setPos(event.getLogPos());
            this.curpos.setTime(event.getHeader().getWhen() * 1000L);
        } else {
            log.info("------------------\u505a\u4e3b\u5907\u5207\u6362,\u539f\u4e3b\u673a\u6e90[{}],\u5207\u6362\u6e90[{}}]--------------------------------", (Object)this.uuid, (Object)event.getSource());
            this.gtids = null;
        }
    }

    public ListenerConf.Position getCurpos() {
        return this.savepos == null ? this.curpos.build() : this.savepos.build();
    }

    public ListenerConf.CheckPoint getCheckPointCur() {
        ListenerConf.Position curpos = this.getCurpos();
        return this.getCheckPoint(curpos);
    }

    public ListenerConf.CheckPoint getCheckPoint(long time) {
        ListenerConf.Position findTime = this.saveCheckPoint.findPoint(time);
        return this.getCheckPoint(findTime);
    }

    public void setColHis(List<ListenerConf.ColHis> colHisList) {
        if (CollectionUtils.isEmpty(colHisList)) {
            return;
        }
        for (ListenerConf.ColHis colHis : colHisList) {
            String key = BusiAssit.getColHiskey(colHis.getDb(), colHis.getTb());
            if (this.colsMap.containsKey(key)) {
                List<ListenerConf.ColHis> list = this.colsMap.get(key);
                boolean has = false;
                for (ListenerConf.ColHis ele : list) {
                    if (ele.getTime() != colHis.getTime()) continue;
                    has = true;
                    break;
                }
                if (has) continue;
                list.add(colHis);
                continue;
            }
            ArrayList<ListenerConf.ColHis> templist = new ArrayList<ListenerConf.ColHis>();
            templist.add(colHis);
            this.colsMap.put(key, templist);
        }
        for (ListenerConf.ColHis colHis2 : colHisList) {
            this.saveCheckPoint.saveColName(colHis2);
        }
        for (String key : this.colsMap.keySet()) {
            if (this.colsMap.get(key).size() < 2) continue;
            Collections.sort(this.colsMap.get(key), new Comparator<ListenerConf.ColHis>(){

                @Override
                public int compare(ListenerConf.ColHis o1, ListenerConf.ColHis o2) {
                    long def = o2.getTime() - o1.getTime();
                    return def > 0L ? 1 : (def < 0L ? -1 : 0);
                }
            });
        }
    }

    private ListenerConf.CheckPoint getCheckPoint(ListenerConf.Position findPoint) {
        List<ListenerConf.ColHis> colsList = this.saveCheckPoint.findColsAll();
        ListenerConf.CheckPoint.Builder checkPointBuilder = ListenerConf.CheckPoint.newBuilder();
        checkPointBuilder.setPos(findPoint);
        checkPointBuilder.addAllCols(colsList);
        return checkPointBuilder.build();
    }

    @Override
    public void close() {
        this.isClose = true;
        if (this.savepos != null) {
            this.saveCheckPoint.savePoint(this.savepos.build());
        }
        try {
            if (this.scheduleAtFixedRate != null) {
                this.scheduleAtFixedRate.cancel(true);
            }
            log.info("============1close timerService Thread sucess");
            if (this.timerService != null) {
                this.timerService.shutdown();
                log.info("============2close timerService pool sucess");
            }
        }
        catch (Throwable e) {
            log.error("\u5173\u95ed\u5b9a\u65f6\u5668\u5931\u8d25", e);
        }
        if (super.getBinlogListener() != null) {
            try {
                super.getBinlogListener().close();
                log.info("============3close BinlogListener2 sucess");
            }
            catch (Throwable e) {
                log.error("\u5173\u95ed\u76d1\u542c\u8005\u5931\u8d25", e);
            }
        }
        if (this.fecther != null) {
            try {
                this.fecther.close();
                log.info("============4close fecther sucess");
            }
            catch (Throwable e) {
                log.error("\u5173\u95edfecther\u5931\u8d25", e);
            }
        }
    }

    public String getVar(Connection conn, String var, boolean isGlobal) throws SQLException {
        String sql = String.format("select @@%s%s", isGlobal ? "GLOBAL." : "", var);
        ResultSet resultSet = JdbcAssit.querySql((Connection)conn, (String)sql);
        resultSet.next();
        String retstr = resultSet.getString(1);
        resultSet.close();
        return retstr;
    }

    public boolean isAvailable(Connection conn, String gtidStr, String uuid) throws SQLException {
        if (StringUtil.isNull((Object)gtidStr)) {
            return false;
        }
        long maxGtidDel = this.maxGtid(this.getVar(conn, "GTID_PURGED", true), uuid);
        long maxGtidCur = this.maxGtid(gtidStr.replace("\n", ""), uuid);
        return maxGtidDel == 0L || maxGtidDel > 0L && maxGtidCur > 0L && maxGtidCur > maxGtidDel;
    }

    private long maxGtid(String gtidStr, String uuid) {
        if (StringUtil.isNull((Object)gtidStr)) {
            return 0L;
        }
        String[] gtidAry = gtidStr.split(",");
        long delmax = 0L;
        for (String eleGtid : gtidAry) {
            if (!eleGtid.startsWith(uuid)) continue;
            int index1 = eleGtid.lastIndexOf(":");
            String[] nums = eleGtid.substring(index1 + 1).split("-");
            String delNumStr = nums.length > 1 ? nums[1] : nums[0];
            delmax = Long.parseLong(delNumStr);
            break;
        }
        return delmax;
    }

    private void initSlaveGtids(String gtids) {
        if (StringUtil.isNotNull((Object)gtids)) {
            Object[] gtidsAry;
            this.gtids = gtids.replace("\n", "");
            for (String string : gtidsAry = this.gtids.split(",")) {
                if (!string.startsWith(this.uuid)) continue;
                gtidsAry = (String[])ArrayUtils.removeElement((Object[])gtidsAry, (Object)string);
                break;
            }
            this.slaveGtids = CollectionUtil.arrayJoin((Object[])gtidsAry, (String)",");
        }
    }

    private ListenerConf.Position getMastStatus(ListenerConf.ConnConf.Builder connConfBuilder) {
        String url = String.format("jdbc:mysql://%s:%s?autoReconnect=true&useUnicode=true&characterEncoding=utf-8", connConfBuilder.getIp(), connConfBuilder.getPort());
        Connection conn = JdbcConnection.getConnection((String)"com.mysql.jdbc.Driver", (String)url, (String)connConfBuilder.getUser(), (String)connConfBuilder.getPassword());
        ResultSet rs = JdbcAssit.querySql((Connection)conn, (String)"show master status");
        try {
            if (rs.next()) {
                String filename = rs.getString(1);
                long pos = rs.getLong(2);
                ListenerConf.Position.Builder ret = ListenerConf.Position.newBuilder();
                ret.setFileName(filename);
                ret.setPos(pos);
                if (rs.getMetaData().getColumnCount() >= 5) {
                    String gtidStr = rs.getString(5);
                    ret.setGtids(gtidStr.replace("/n", ""));
                }
                if ((rs = JdbcAssit.querySql((Connection)conn, (String)"show variables like 'server_id'")).next()) {
                    long masterServerId = rs.getLong(2);
                    ret.setMasterServerId(masterServerId);
                }
                if ((rs = JdbcAssit.querySql((Connection)conn, (String)"SELECT unix_timestamp(now())")).next()) {
                    ret.setTime(rs.getLong(1) * 1000L);
                }
                ListenerConf.Position position = ret.build();
                return position;
            }
            try {
                throw new RuntimeException("\u6ca1\u6709\u5f97\u5230mastStatus,\u670d\u52a1\u5668\u4e0d\u652f\u6301binlog");
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                rs.close();
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

