/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone.parser;

import io.thekraken.grok.api.Match;
import io.thekraken.grok.api.exception.GrokException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.apiext.GrokObj;
import net.wicp.tams.common.apiext.PwdUtil;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.UUIDGenerator;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.apiext.jdbc.JdbcConnection;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.normalize.IBinlogListener;
import net.wicp.tams.common.binlog.alone.normalize.ISaveCheckPoint;
import net.wicp.tams.common.binlog.alone.parser.BinlogMetricGroup;
import net.wicp.tams.common.binlog.parser.event.GtidLogEvent;
import net.wicp.tams.common.binlog.parser.event.QueryLogEvent;
import net.wicp.tams.common.binlog.parser.event.RowsLogBuffer;
import net.wicp.tams.common.binlog.parser.event.RowsLogEvent;
import net.wicp.tams.common.binlog.parser.event.TableMapLogEvent;
import net.wicp.tams.common.binlog.parser.event.XidLogEvent;
import net.wicp.tams.common.constant.DateFormatCase;
import net.wicp.tams.common.constant.OptType;
import net.wicp.tams.common.constant.StrPattern;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.duckula.client.Protobuf3;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseLogFetcher {
    private static final Logger log = LoggerFactory.getLogger(BaseLogFetcher.class);
    protected String fileName = "mysql-bin.000001";
    protected Charset charset = Charset.forName("utf-8");
    protected String gtids;
    private GrokObj gm = GrokObj.getInstance();
    protected final ListenerConf.ConnConf connConf;
    protected final BinlogMetricGroup metric;
    private final IBinlogListener binlogListener;
    protected ISaveCheckPoint saveCheckPoint;
    protected final Map<String, List<ListenerConf.ColHis>> colsMap;
    protected long xid;
    private PreparedStatement prepCols;
    private PreparedStatement prepRowkey;

    public IBinlogListener getBinlogListener() {
        return this.binlogListener;
    }

    protected BaseLogFetcher(ListenerConf.ConnConf.Builder connConfBuilder) {
        this.gm.addPattern("tb", "[A-Za-z0-9_.-:]+");
        this.gm.addPattern("tball", "alter\\s+table\\s+`?%{tb}`?");
        this.gm.addPattern("db", "[A-Za-z0-9_.-:]+");
        this.gm.addPattern("tball2", "alter\\s+table\\s+`?%{db}`.`%{tb}`?");
        this.colsMap = new HashMap<String, List<ListenerConf.ColHis>>();
        Validate.notBlank((CharSequence)connConfBuilder.getIp(), (String)"\u9700\u8981ip\u5730\u5740", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)connConfBuilder.getUser(), (String)"\u9700\u8981\u7528\u6237\u540d", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)connConfBuilder.getPassword(), (String)"\u9700\u8981\u5bc6\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)connConfBuilder.getListener(), (String)"\u9700\u8981\u5904\u7406\u7684\u76d1\u542c\u7c7b", (Object[])new Object[0]);
        if (connConfBuilder.getPort() <= 0) {
            connConfBuilder.setPort(3306);
        }
        if (connConfBuilder.getClientId() <= 0) {
            connConfBuilder.setClientId(StringUtil.buildPort((String)new UUIDGenerator().generate()));
        }
        if (StringUtil.isNull((Object)connConfBuilder.getDbPattern())) {
            connConfBuilder.setDbPattern("^.*$");
        }
        if (StringUtil.isNull((Object)connConfBuilder.getTbPattern())) {
            connConfBuilder.setTbPattern("^.*$");
        }
        if (StringUtil.isNull((Object)connConfBuilder.getChk())) {
            connConfBuilder.setChk("net.wicp.tams.common.binlog.alone.checkpoint.CheckPointH2db");
        }
        this.init(connConfBuilder);
        try {
            this.saveCheckPoint = (ISaveCheckPoint)Class.forName(connConfBuilder.getChk()).newInstance();
            this.saveCheckPoint.init(connConfBuilder);
        }
        catch (Exception e1) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.project_other, "\u521b\u5efacheckpoint\u5b9e\u4f8b\u5931\u8d25");
        }
        this.connConf = connConfBuilder.build();
        this.metric = new BinlogMetricGroup(String.format("%s:%s", this.connConf.getIp(), this.connConf.getPort()));
        Class<?> class1 = null;
        try {
            class1 = Class.forName(this.connConf.getListener());
        }
        catch (ClassNotFoundException e1) {
            log.error("\u6ca1\u6709\u6307\u5b9a\u7684Listener");
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.Param_typenofit, "\u6ca1\u6709\u6307\u5b9a\u7684Listener");
        }
        if (!ReflectAssist.isInterface(class1, (String)"net.wicp.tams.common.binlog.alone.normalize.IBinlogListener")) {
            log.error("Listener\u9700\u8981net.wicp.tams.common.binlog.alone.IBinlogListener\u7c7b\u578b");
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.Param_typenofit, "Listener\u9700\u8981net.wicp.tams.common.binlog.alone.IBinlogListener\u7c7b\u578b");
        }
        try {
            this.binlogListener = (IBinlogListener)class1.newInstance();
        }
        catch (Exception e1) {
            log.error("Listener\u5b9e\u4f8b\u5316\u5931\u8d25");
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.Param_typenofit, "Listener\u5b9e\u4f8b\u5316\u5931\u8d25");
        }
    }

    protected void parseQueryEvent(QueryLogEvent event) {
        String db = event.getDbName();
        String sql = event.getQuery().toLowerCase();
        if (sql.startsWith("alter")) {
            try {
                Match match = this.gm.match("%{tball}", sql);
                String tb = String.valueOf(match.toMap().get("tb"));
                tb = tb.replace(db + ".", "");
                if (db.equals(tb)) {
                    Match match2 = this.gm.match("%{tball2}", sql);
                    tb = String.valueOf(match2.toMap().get("tb"));
                }
                if (!this.isValid(db, tb)) {
                    return;
                }
                this.findCols(db, tb, event.getWhen());
            }
            catch (GrokException e) {
                log.error("get tb from sql error", (Throwable)e);
            }
        }
    }

    protected void parseGtidLogEvent(GtidLogEvent event) throws Exception {
        this.gtids = event.getGtid();
        this.parseGtidLogEventSub(event);
    }

    protected abstract void parseGtidLogEventSub(GtidLogEvent var1);

    protected abstract void init(ListenerConf.ConnConf.Builder var1);

    public abstract void close();

    public abstract void read();

    protected void parseXidEvent(XidLogEvent event) {
        this.xid = event.getXid();
    }

    private boolean isValid(String db, String tb) {
        return StrPattern.checkStrFormat((String)this.connConf.getDbPattern(), (String)db) && StrPattern.checkStrFormat((String)this.connConf.getTbPattern(), (String)tb);
    }

    protected boolean parseRowsEvent(RowsLogEvent event, OptType optType) {
        int i;
        if (log.isDebugEnabled()) {
            Date d = new Date(event.getHeader().getWhen() * 1000L);
            String datestr = DateFormatCase.YYYY_MM_DD_hhmmss.getInstanc().format(d);
            log.debug("db:{},tb:{},time:{}", new Object[]{event.getTable().getDbName(), event.getTable().getTableName(), datestr});
        }
        if (!this.isValid(event.getTable().getDbName(), event.getTable().getTableName())) {
            return false;
        }
        this.metric.meter_parser_pack_row.mark();
        ListenerConf.ColHis colhis = this.ValidKey(event.getTable().getDbName(), event.getTable().getTableName(), event.getWhen());
        ArrayList<String[]> rowListBefore = new ArrayList<String[]>();
        ArrayList<String[]> rowListAfter = new ArrayList<String[]>();
        int rows = 0;
        try {
            RowsLogBuffer buffer = event.getRowsBuf(this.charset.name());
            BitSet columns = event.getColumns();
            BitSet changeColumns = event.getChangeColumns();
            while (buffer.nextOneRow(columns)) {
                int type = event.getHeader().getType();
                if (23 == type || 30 == type) {
                    rowListAfter.add(this.parseOneRow(event, buffer, columns, colhis.getColsCount(), true));
                } else if (25 == type || 32 == type) {
                    rowListBefore.add(this.parseOneRow(event, buffer, columns, colhis.getColsCount(), false));
                } else {
                    rowListBefore.add(this.parseOneRow(event, buffer, columns, colhis.getColsCount(), true));
                    if (!buffer.nextOneRow(changeColumns)) break;
                    rowListAfter.add(this.parseOneRow(event, buffer, changeColumns, colhis.getColsCount(), true));
                }
                ++rows;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("parse row data failed.", e);
        }
        String[][] afterArray = new String[rowListAfter.size()][];
        for (int i2 = 0; i2 < rowListAfter.size(); ++i2) {
            afterArray[i2] = (String[])rowListAfter.get(i2);
        }
        String[][] beforeArray = new String[rowListBefore.size()][];
        for (int i3 = 0; i3 < rowListBefore.size(); ++i3) {
            beforeArray[i3] = (String[])rowListBefore.get(i3);
        }
        Protobuf3.DuckulaEvent.Builder duckulaEventBuilder = Protobuf3.DuckulaEvent.newBuilder();
        duckulaEventBuilder.setColNum(ArrayUtils.isNotEmpty((Object[])afterArray) ? afterArray[0].length : beforeArray[0].length);
        duckulaEventBuilder.addAllCols((Iterable)colhis.getColsList());
        TableMapLogEvent.ColumnInfo[] colsColumnInfo = event.getTable().getColumnInfo();
        for (i = 0; i < colsColumnInfo.length; ++i) {
            duckulaEventBuilder.addColsTypeValue(colsColumnInfo[i].type);
        }
        duckulaEventBuilder.setDb(event.getTable().getDbName());
        duckulaEventBuilder.setTb(event.getTable().getDbName());
        duckulaEventBuilder.setGtid(this.gtids);
        duckulaEventBuilder.setIsError(false);
        duckulaEventBuilder.setOptType(Protobuf3.OptType.forNumber((int)optType.getValue()));
        for (i = 0; i < rows; ++i) {
            Protobuf3.DuckulaEvent.Builder rowBuilder = duckulaEventBuilder.clone();
            this.initData(rowBuilder, rowListBefore, (List<String>)colhis.getColsList(), i);
            this.initData(rowBuilder, rowListAfter, (List<String>)colhis.getColsList(), i);
            this.binlogListener.doBui(rowBuilder.build());
        }
        this.metric.meter_parser_event.mark((long)rows);
        this.metric.counter_ringbuff_pack.inc();
        this.metric.counter_ringbuff_event.inc((long)rows);
        return true;
    }

    protected String[] parseOneRow(RowsLogEvent event, RowsLogBuffer buffer, BitSet cols, int colsNum, boolean isAfter) throws UnsupportedEncodingException {
        TableMapLogEvent map = event.getTable();
        if (map == null) {
            throw new RuntimeException("not found TableMap with tid=" + event.getTableId());
        }
        if (colsNum != event.getTable().getColumnCnt()) {
            throw new RuntimeException("TableMap:" + event.getTableId() + " the colsname is:" + colsNum + " the value size is:" + event.getTable().getColumnCnt());
        }
        String[] values = new String[event.getTable().getColumnCnt()];
        int columnCnt = map.getColumnCnt();
        TableMapLogEvent.ColumnInfo[] columnInfo = map.getColumnInfo();
        for (int i = 0; i < columnCnt; ++i) {
            if (!cols.get(i)) continue;
            TableMapLogEvent.ColumnInfo info = columnInfo[i];
            buffer.nextValue(info.type, info.meta);
            if (buffer.isNull()) continue;
            Serializable value = buffer.getValue();
            values[i] = value instanceof byte[] ? PwdUtil.base64FromBin((byte[])((byte[])value)) : String.valueOf(value);
        }
        return values;
    }

    public ListenerConf.ColHis findCols(String db, String tb, long time) {
        String key = String.format("%s|%s", db, tb).toLowerCase();
        Connection conn = null;
        try {
            String url = String.format("jdbc:mysql://%s:%s?autoReconnect=true&useUnicode=true&characterEncoding=utf-8", this.connConf.getIp(), this.connConf.getPort());
            conn = JdbcConnection.getConnection((String)"com.mysql.jdbc.Driver", (String)url, (String)this.connConf.getUser(), (String)this.connConf.getPassword());
            if (this.prepCols == null || this.prepCols.isClosed()) {
                this.prepCols = conn.prepareStatement("select   column_name,data_type   from  information_schema.columns  where  table_schema=? and table_name=?");
            }
            ArrayList<String> ret = new ArrayList<String>();
            ArrayList<String> retType = new ArrayList<String>();
            JdbcAssit.setPreParam((PreparedStatement)this.prepCols, (Object[])new Object[]{db, tb});
            ResultSet rs = this.prepCols.executeQuery();
            while (rs.next()) {
                ret.add(rs.getString(1));
                retType.add(rs.getString(2));
            }
            rs.close();
            if (CollectionUtils.isEmpty(ret)) {
                log.error("db:{},td:{},user:{} \u6ca1\u6709s\u67e5\u8be2\u5230\u5217\u540d\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u662f\u5426\u6709\u6b64\u6743\u9650", new Object[]{db, tb, this.connConf.getUser()});
                this.close();
            }
            if (this.connConf.getRds()) {
                if (this.prepRowkey == null || this.prepRowkey.isClosed()) {
                    this.prepRowkey = conn.prepareStatement("SELECT k.column_name FROM information_schema.table_constraints t JOIN information_schema.key_column_usage k USING (constraint_name,table_schema,table_name) WHERE t.constraint_type='PRIMARY KEY' AND t.table_schema=? AND t.table_name=?");
                }
                JdbcAssit.setPreParam((PreparedStatement)this.prepRowkey, (Object[])new Object[]{db, tb});
                ResultSet rs2 = this.prepRowkey.executeQuery();
                if (!rs2.next()) {
                    ret.add("_rowkey_");
                    retType.add("varchar");
                }
                rs2.close();
            }
            ListenerConf.ColHis.Builder ColHisBuilder = ListenerConf.ColHis.newBuilder();
            ColHisBuilder.setTime(time);
            ColHisBuilder.setDb(db);
            ColHisBuilder.setTb(tb);
            ColHisBuilder.addAllCols(ret);
            ColHisBuilder.addAllColTypes(retType);
            ListenerConf.ColHis retobj = ColHisBuilder.build();
            this.saveCheckPoint.saveColName(retobj);
            List<ListenerConf.ColHis> findColsList = this.saveCheckPoint.findColsList(db, tb);
            Collections.sort(findColsList, new Comparator<ListenerConf.ColHis>(){

                @Override
                public int compare(ListenerConf.ColHis o1, ListenerConf.ColHis o2) {
                    long def = o2.getTime() - o1.getTime();
                    return def > 0L ? 1 : (def < 0L ? -1 : 0);
                }
            });
            this.colsMap.put(key, findColsList);
            ListenerConf.ColHis colHis = retobj;
            return colHis;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6cols\u9519\u8bef", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6cols\u9519\u8bef");
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    log.error("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    public ListenerConf.ColHis ValidKey(String db, String tb, long time) {
        String key = String.format("%s|%s", db, tb).toLowerCase();
        if (this.colsMap.containsKey(key)) {
            List<ListenerConf.ColHis> list = this.colsMap.get(key);
            ListenerConf.ColHis selFitColName = this.selFitColName(time, list);
            if (selFitColName == null) {
                throw new RuntimeException("\u6ca1\u6709\u53ef\u7528\u7684col\u4fe1\u606f\u3002");
            }
            return selFitColName;
        }
        List<ListenerConf.ColHis> findColsList = this.saveCheckPoint.findColsList(db, tb);
        if (CollectionUtils.isEmpty(findColsList)) {
            ListenerConf.ColHis retobj = this.findCols(db, tb, -1L);
            ArrayList<ListenerConf.ColHis> retlist = new ArrayList<ListenerConf.ColHis>();
            retlist.add(retobj);
            this.colsMap.put(key, retlist);
            return retobj;
        }
        Collections.sort(findColsList, new Comparator<ListenerConf.ColHis>(){

            @Override
            public int compare(ListenerConf.ColHis o1, ListenerConf.ColHis o2) {
                long def = o2.getTime() - o1.getTime();
                return def > 0L ? 1 : (def < 0L ? -1 : 0);
            }
        });
        this.colsMap.put(key, findColsList);
        ListenerConf.ColHis selFitColName = this.selFitColName(time, findColsList);
        if (selFitColName == null) {
            throw new RuntimeException("\u6ca1\u6709\u53ef\u7528\u7684col\u4fe1\u606f\u3002");
        }
        return selFitColName;
    }

    private ListenerConf.ColHis selFitColName(long time, List<ListenerConf.ColHis> list) {
        for (int i = 0; i < list.size(); ++i) {
            ListenerConf.ColHis colHis = list.get(i);
            if (colHis.getTime() >= time) continue;
            return colHis;
        }
        return null;
    }

    private void initData(Protobuf3.DuckulaEvent.Builder rowbuilder, List<String[]> datas, List<String> cols, int rowNo) {
        if (CollectionUtils.isEmpty(datas)) {
            return;
        }
        String[] tempary = datas.get(rowNo);
        for (int i = 0; i < tempary.length; ++i) {
            if (tempary[i] == null) continue;
            rowbuilder.putAfter(cols.get(i), tempary[i]);
        }
    }
}

