/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone.checkpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.binlog.alone.BusiAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.normalize.ISaveCheckPoint;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckPointMemory
implements ISaveCheckPoint {
    private static final Logger log = LoggerFactory.getLogger(CheckPointMemory.class);
    private final List<PositionPack> posList = new ArrayList<PositionPack>();
    private final int maxPosSize = 100;
    private final Map<String, List<ListenerConf.ColHis>> colMap = new HashMap<String, List<ListenerConf.ColHis>>();

    @Override
    public void init(ListenerConf.ConnConf.Builder connConfBuilder) {
    }

    @Override
    public void shutdown() {
        this.posList.clear();
        this.colMap.clear();
    }

    @Override
    public void savePoint(ListenerConf.Position pos) {
        PositionPack positionPack = new PositionPack(pos);
        if (!this.posList.contains(positionPack)) {
            this.posList.add(positionPack);
            if (this.posList.size() > 100) {
                PositionPack l1 = this.posList.get(this.posList.size() - 1);
                PositionPack l2 = this.posList.get(this.posList.size() - 2);
                PositionPack l3 = this.posList.get(this.posList.size() - 3);
                this.posList.clear();
                this.posList.add(l3);
                this.posList.add(l2);
                this.posList.add(l1);
            }
        }
    }

    @Override
    public void saveColName(ListenerConf.ColHis colHis) {
        log.info("the newer colHis is:{}", (Object)colHis);
        String key = BusiAssit.getColHiskey(colHis.getDb(), colHis.getTb());
        if (this.colMap.containsKey(key)) {
            List<ListenerConf.ColHis> templist = this.colMap.get(key);
            templist.add(colHis);
            Collections.sort(templist, new Comparator<ListenerConf.ColHis>(){

                @Override
                public int compare(ListenerConf.ColHis o1, ListenerConf.ColHis o2) {
                    long def = o2.getTime() - o1.getTime();
                    return def > 0L ? 1 : (def == 0L ? 0 : -1);
                }
            });
            this.colMap.put(key, templist);
        } else {
            ArrayList<ListenerConf.ColHis> templist = new ArrayList<ListenerConf.ColHis>();
            templist.add(colHis);
            this.colMap.put(key, templist);
        }
    }

    @Override
    public ListenerConf.Position findPoint(long time) {
        for (int i = this.posList.size(); i > 0; --i) {
            PositionPack positionPack = this.posList.get(i);
            if (positionPack.getPos().getTime() > time) continue;
            return positionPack.getPos();
        }
        return null;
    }

    @Override
    public List<ListenerConf.ColHis> findColsList(String db, String tb) {
        String key = BusiAssit.getColHiskey(db, tb);
        if (CollectionUtils.isEmpty((Collection)this.colMap.get(key))) {
            return new ArrayList<ListenerConf.ColHis>();
        }
        return this.colMap.get(key);
    }

    @Override
    public List<ListenerConf.ColHis> findColsAll() {
        ArrayList<ListenerConf.ColHis> allColHis = new ArrayList<ListenerConf.ColHis>();
        for (String key : this.colMap.keySet()) {
            allColHis.addAll((Collection<ListenerConf.ColHis>)this.colMap.get(key));
        }
        return allColHis;
    }

    private class PositionPack {
        private final ListenerConf.Position pos;
        private String gtids;

        public PositionPack(ListenerConf.Position pos) {
            this.pos = pos;
            this.gtids = pos.getGtids();
        }

        public boolean equals(Object PositionPack2) {
            PositionPack temp = (PositionPack)PositionPack2;
            return this.pos.getGtids().equals(temp.getGtids());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.gtids == null ? 0 : this.gtids.hashCode());
            return result;
        }

        public ListenerConf.Position getPos() {
            return this.pos;
        }

        public String getGtids() {
            return this.gtids;
        }

        public void setGtids(String gtids) {
            this.gtids = gtids;
        }

        public String toString() {
            return "CheckPointMemory.PositionPack(pos=" + this.getPos() + ", gtids=" + this.getGtids() + ")";
        }
    }
}

