/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone.checkpoint;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.normalize.ISaveCheckPoint;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckPointH2db
implements ISaveCheckPoint {
    private static final Logger log = LoggerFactory.getLogger(CheckPointH2db.class);
    private Connection connection = null;
    private String url = "";
    private PreparedStatement pointPrep;
    private PreparedStatement colSaveColsPre;
    private PreparedStatement queryPointPre;
    private PreparedStatement queryColsPre;

    @Override
    public void init(ListenerConf.ConnConf.Builder connConfBuilder) {
        try {
            Class.forName("org.h2.Driver");
            String databaseName = String.format("%s_%s", connConfBuilder.getIp(), connConfBuilder.getPort());
            String dirpath = StringUtil.hasNull((String[])new String[]{System.getenv("H2_DIR"), Conf.get((String)"common.binlog.alone.h2.dir")});
            this.url = IOUtil.mergeFolderAndFilePath((String)"jdbc:h2:~/", (String[])new String[]{dirpath, databaseName + ";AUTO_RECONNECT=TRUE;AUTO_SERVER=TRUE"});
            this.connection = DriverManager.getConnection(this.url, "sa", "");
            Statement stmt = this.connection.createStatement();
            int executeUpdate = stmt.executeUpdate("CREATE TABLE IF NOT EXISTS `position`  (`gtids` varchar(500) NOT NULL,`fileName` varchar(255) NULL,`pos` long NULL,`masterServerId` long NULL,`time` long NULL,PRIMARY KEY (`gtids`))");
            int executeUpdate2 = stmt.executeUpdate("CREATE TABLE IF NOT EXISTS `colhis`  (`db` varchar(300) NOT NULL,`tb` varchar(300) NOT NULL,`time` long NOT NULL,`cols` varchar(5000) NOT NULL,`coltypes` varchar(3000) NOT NULL,PRIMARY KEY (`db`,`tb`, `time`))");
            stmt.close();
            if (executeUpdate != 0 || executeUpdate2 != 0) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.jdbc_exec_fail, "\u521b\u5efatable\u5931\u8d25");
            }
            log.info("execute=" + executeUpdate);
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            log.error("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void savePoint(ListenerConf.Position pos) {
        this.pointPrep = this.checkStmt("replace into position(gtids,filename,pos,masterserverid,time) values(?,?,?,?,?)", this.pointPrep);
        try {
            JdbcAssit.setPreParam((PreparedStatement)this.pointPrep, (Object[])new Object[]{pos.getGtids(), pos.getFileName(), pos.getPos(), pos.getMasterServerId(), pos.getTime()});
            this.pointPrep.executeUpdate();
            log.info("\u4fdd\u5b58\u4f4d\u70b9{}\u6210\u529f", (Object)pos.getGtids());
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u4f4d\u70b9\u5931\u8d25", (Throwable)e);
        }
    }

    private PreparedStatement checkStmt(String sql, PreparedStatement stmt) {
        PreparedStatement returnobj = stmt;
        while (true) {
            try {
                if (this.connection == null || this.connection.isClosed()) {
                    if (stmt != null && stmt.isClosed()) {
                        stmt.close();
                    }
                    this.connection = DriverManager.getConnection(this.url, "sa", "");
                }
                if (stmt != null) break;
                returnobj = this.connection.prepareStatement(sql);
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u4e0a\u6216\u521b\u5efastmt\u5931\u8d25", (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
        return returnobj;
    }

    @Override
    public void saveColName(ListenerConf.ColHis colHis) {
        this.colSaveColsPre = this.checkStmt("replace into colhis(db,tb,time,cols,coltypes) values(?,?,?,?,?)", this.colSaveColsPre);
        try {
            String cols = CollectionUtil.listJoin((List)colHis.getColsList(), (String)",");
            String colstype = CollectionUtil.listJoin((List)colHis.getColTypesList(), (String)",");
            JdbcAssit.setPreParam((PreparedStatement)this.colSaveColsPre, (Object[])new Object[]{colHis.getDb(), colHis.getTb(), colHis.getTime(), cols, colstype});
            this.colSaveColsPre.executeUpdate();
            log.info("\u4fdd\u5b58\u5b57\u6bb5\u540d\u6210\u529f,db{},tb{},time{}", new Object[]{colHis.getDb(), colHis.getTb(), colHis.getTime()});
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u4f4d\u70b9\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ListenerConf.Position findPoint(long time) {
        this.queryPointPre = this.checkStmt("select * from position  where time<=?  order by time desc limit 0,1", this.queryPointPre);
        ListenerConf.Position retojb = null;
        try {
            JdbcAssit.setPreParam((PreparedStatement)this.queryPointPre, (Object[])new Object[]{this.queryPointPre});
            ResultSet executeQuery = this.queryPointPre.executeQuery();
            if (executeQuery.next()) {
                ListenerConf.Position.Builder builder = ListenerConf.Position.newBuilder();
                builder.setFileName(executeQuery.getString("fileName"));
                builder.setGtids(executeQuery.getString("gtids"));
                builder.setPos(executeQuery.getLong("pos"));
                builder.setMasterServerId(executeQuery.getLong("masterServerId"));
                builder.setTime(executeQuery.getLong("time"));
                retojb = builder.build();
            }
        }
        catch (SQLException e) {
            log.error("\u67e5\u8be2\u4f4d\u70b9\u5931\u8d25", (Throwable)e);
        }
        return retojb;
    }

    @Override
    public List<ListenerConf.ColHis> findColsList(String db, String tb) {
        this.queryColsPre = this.checkStmt("select * from colhis  where db=? and tb=? order by time desc", this.queryColsPre);
        ArrayList<ListenerConf.ColHis> retlist = new ArrayList<ListenerConf.ColHis>();
        try {
            JdbcAssit.setPreParam((PreparedStatement)this.queryColsPre, (Object[])new Object[]{db, tb});
            ResultSet resultSet = this.queryColsPre.executeQuery();
            while (resultSet.next()) {
                ListenerConf.ColHis.Builder tempBuilder = ListenerConf.ColHis.newBuilder();
                tempBuilder.setDb(db);
                tempBuilder.setTb(tb);
                tempBuilder.setTime(resultSet.getLong("time"));
                String[] colsAry = resultSet.getString("cols").split(",");
                tempBuilder.addAllCols(Arrays.asList(colsAry));
                String[] coltypesAry = resultSet.getString("coltypes").split(",");
                tempBuilder.addAllColTypes(Arrays.asList(coltypesAry));
                retlist.add(tempBuilder.build());
            }
            resultSet.close();
        }
        catch (Exception e) {
            log.error("\u67e5colname\u5931\u8d25", (Throwable)e);
        }
        return retlist;
    }

    @Override
    public List<ListenerConf.ColHis> findColsAll() {
        ArrayList<ListenerConf.ColHis> retlist = new ArrayList<ListenerConf.ColHis>();
        try {
            ResultSet resultSet = JdbcAssit.querySql((Connection)this.connection, (String)"select * from colhis order by time desc");
            while (resultSet.next()) {
                ListenerConf.ColHis.Builder tempBuilder = ListenerConf.ColHis.newBuilder();
                tempBuilder.setDb(resultSet.getString("db"));
                tempBuilder.setTb(resultSet.getString("tb"));
                tempBuilder.setTime(resultSet.getLong("time"));
                String[] colsAry = resultSet.getString("cols").split(",");
                tempBuilder.addAllCols(Arrays.asList(colsAry));
                String[] coltypesAry = resultSet.getString("coltypes").split(",");
                tempBuilder.addAllColTypes(Arrays.asList(coltypesAry));
                retlist.add(tempBuilder.build());
            }
            resultSet.close();
        }
        catch (Exception e) {
            log.error("\u67e5colname all\u5931\u8d25", (Throwable)e);
        }
        return retlist;
    }
}

