package net.wicp.tams.common.binlog.alone.normalize;

import java.util.List;

import net.wicp.tams.common.binlog.alone.ListenerConf.ColHis;
import net.wicp.tams.common.binlog.alone.ListenerConf.ConnConf;
import net.wicp.tams.common.binlog.alone.ListenerConf.Position;

/***
 * checkpoint保存接口，默认会以文件存储的方式实现，在flink需要自己管理。
 * 
 * @author andy.zhou
 *
 */
public interface ISaveCheckPoint {
	/***
	 * 初始化，如启动服务，或是创建连接等。
	 */
	public void init(ConnConf.Builder connConfBuilder);

	/***
	 * 在JVM退出时要做的清理工作
	 */
	public void shutdown();

	public void savePoint(Position pos);

	/****
	 * db/tb/timestamp联合唯一索引,这个肯定会有存储，为了性能，请尽量在此地方保证有序，因为它调用的次数是远远小于findColsList方法，
	 * 如果在findColsList方法去排序将得不偿失
	 * 
	 * @param colHis
	 */
	public void saveColName(ColHis colHis);

	/***
	 * 找到指定时间前最近的一个位点
	 * 
	 * @param time
	 * @return
	 */
	public Position findPoint(long time);

	/***
	 * 找到指定时间后的所有字段名
	 * 
	 * @param db
	 * @param tb
	 * @return
	 */
	public List<ColHis> findColsList(String db, String tb);

	/****
	 * 查所以的列
	 * 
	 * @return
	 */
	public List<ColHis> findColsAll();
}
